/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateCustomization;
import org.flasck.flas.parsedForm.TemplateEvent;
import org.flasck.flas.parsedForm.TemplateField;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAParseTemplateElements;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDATemplateOptionsParser
extends BlockLocationTracker
implements TDAParsing {
    private final Template source;
    private final TemplateNamer namer;
    private final TemplateBinding binding;
    private final TemplateCustomization customizer;
    private final TemplateField field;
    private boolean seenContent;

    public TDATemplateOptionsParser(ErrorReporter errors, Template source, TemplateNamer namer, TemplateBinding binding, TemplateField field, LocationTracker endofTemplate) {
        super(errors, endofTemplate);
        this.source = source;
        this.namer = namer;
        this.binding = binding;
        this.customizer = binding;
        this.field = field;
    }

    public TDATemplateOptionsParser(ErrorReporter errors, Template source, TemplateNamer namer, TemplateBindingOption option, TemplateField field, LocationTracker endOfTemplate) {
        super(errors, endOfTemplate);
        this.source = source;
        this.namer = namer;
        this.customizer = option;
        this.field = field;
        this.binding = null;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        this.seenContent = true;
        ExprToken tok = ExprToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        if ("|".equals(tok.text)) {
            InputPosition barPos = tok.location;
            if ((this.binding == null || this.binding.defaultBinding != null) && this.toksHasSend(toks)) {
                this.errors.message(toks, "conditional bindings are not permitted after the default has been specified");
                return new IgnoreNestedParser(this.errors);
            }
            if (this.binding != null && this.binding.defaultBinding != null) {
                this.errors.message(tok.location, "cannot mix bindings and customization");
            }
            if (this.toksHasSend(toks)) {
                return TDAParseTemplateElements.parseConditionalBindingOption(this.errors, barPos, this.source, this.namer, toks, this.field, tbo -> this.binding.conditionalBindings.add((TemplateBindingOption)tbo), this.parentTracker());
            }
            return TDAParseTemplateElements.parseStyling(this.errors, tok.location, this.source, this.namer, toks, tso -> this.customizer.conditionalStylings.add((TemplateStylingOption)tso), this.parentTracker());
        }
        if ("<-".equals(tok.text)) {
            if (this.binding == null) {
                this.errors.message(toks, "syntax error");
                return new IgnoreNestedParser(this.errors);
            }
            if (this.binding.defaultBinding != null) {
                this.errors.message(toks, "multiple default bindings are not permitted");
                return new IgnoreNestedParser(this.errors);
            }
            return TDAParseTemplateElements.parseDefaultBindingOption(this.errors, tok.location, this.source, this.namer, toks, this.field, tbo -> {
                this.binding.defaultBinding = tbo;
            }, this.parentTracker());
        }
        if ("=>".equals(tok.text)) {
            return TDAParseTemplateElements.parseEventHandling(tok, this.errors, this.source, toks, ev -> this.customizer.events.add((TemplateEvent)ev), this.parentTracker());
        }
        this.errors.message(toks, "syntax error");
        return new IgnoreNestedParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition pos) {
        if (this.binding != null && !this.seenContent) {
            this.errors.message(this.binding.assignsTo.location(), "simple template name must have options or customization");
            return;
        }
        if (this.binding != null) {
            InputPosition first = null;
            InputPosition last = null;
            String opt = "";
            if (!this.binding.conditionalBindings.isEmpty()) {
                first = this.binding.conditionalBindings.get(0).location();
                last = this.binding.conditionalBindings.get(this.binding.conditionalBindings.size() - 1).location();
            }
            if (this.binding.defaultBinding != null) {
                last = this.binding.defaultBinding.location();
                if (first == null) {
                    first = last;
                }
                opt = "-with-default";
            }
            if (first != null && last != null) {
                this.errors.logReduction("template-binds" + opt, first, last);
            }
        }
    }

    private boolean toksHasSend(Tokenizable toks) {
        ExprToken tok;
        int mark = toks.at();
        boolean ret = false;
        while (toks.hasMoreContent(this.errors) && (tok = ExprToken.from(this.errors, toks)) != null) {
            if (!tok.text.equals("<-")) continue;
            ret = true;
            break;
        }
        toks.reset(mark);
        return ret;
    }
}

