/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateField;
import org.flasck.flas.parsedForm.TemplateReference;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParseTemplateElements;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDATemplateOptionsParser;
import org.flasck.flas.parser.TemplateBindingConsumer;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.TemplateNameToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDATemplateBindingParser
extends BlockLocationTracker
implements TDAParsing {
    private final Template source;
    private final TemplateNamer namer;
    private final TemplateBindingConsumer consumer;

    public TDATemplateBindingParser(ErrorReporter errors, Template source, TemplateNamer namer, TemplateBindingConsumer consumer, LocationTracker locTracker) {
        super(errors, locTracker);
        this.source = source;
        this.namer = namer;
        this.consumer = consumer;
        this.updateLoc(source.kwlocation());
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        TemplateNameToken tok = TemplateNameToken.from(this.errors, toks);
        if (tok == null) {
            ExprToken et = ExprToken.from(this.errors, toks);
            if (et != null && et.text.equals("|")) {
                return TDAParseTemplateElements.parseStyling(this.errors, et.location, this.source, this.namer, toks, x -> this.consumer.addStyling((TemplateStylingOption)x), this);
            }
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        TemplateField field = new TemplateField(tok.location, tok.text);
        InputPosition lastLoc = field.location();
        TemplateBindingOption simple = null;
        ExprToken send = null;
        TemplateReference sendsTo = null;
        if (toks.hasMoreContent(this.errors)) {
            send = ExprToken.from(this.errors, toks);
            if (send == null || !"<-".equals(send.text)) {
                if ("=>".equals(send.text)) {
                    this.errors.message(toks, "missing expression");
                } else {
                    this.errors.message(toks, "syntax error");
                }
                return new IgnoreNestedParser(this.errors);
            }
            Expr expr = null;
            if ("<-".equals(send.text)) {
                ArrayList seen = new ArrayList();
                new TDAExpressionParser(this.errors, t -> seen.add(t)).tryParsing(toks);
                if (seen.isEmpty()) {
                    this.errors.message(toks, "no expression to send");
                    return new IgnoreNestedParser(this.errors);
                }
                expr = (Expr)seen.get(0);
                lastLoc = expr.location();
            }
            if (toks.hasMoreContent(this.errors)) {
                ExprToken format = ExprToken.from(this.errors, toks);
                if (format == null || !"=>".equals(format.text)) {
                    this.errors.message(toks, "syntax error");
                    return new IgnoreNestedParser(this.errors);
                }
                TemplateNameToken dest = TemplateNameToken.from(this.errors, toks);
                if (dest == null) {
                    this.errors.message(toks, "missing template name");
                    return new IgnoreNestedParser(this.errors);
                }
                lastLoc = dest.location;
                sendsTo = new TemplateReference(dest.location, this.namer.template(dest.location, dest.text));
                this.errors.logReduction("pass-to-template", format, dest);
            }
            simple = new TemplateBindingOption(tok.location, field, null, expr, sendsTo);
        }
        if (send == null) {
            this.errors.logReduction("template-binding-no-send", tok.location, lastLoc);
        } else if (sendsTo == null) {
            this.errors.logReduction("template-binding-with-send", tok.location, lastLoc);
        } else {
            this.errors.logReduction("template-binding-with-send-sends-to", tok.location, lastLoc);
        }
        TemplateBinding binding = new TemplateBinding(field, simple);
        this.consumer.addBinding(binding);
        TDATemplateOptionsParser ret = simple != null ? new TDATemplateOptionsParser(this.errors, this.source, this.namer, simple, field, (LocationTracker)this) : new TDATemplateOptionsParser(this.errors, this.source, this.namer, binding, field, (LocationTracker)this);
        return new TDAParsingWithAction(ret, this.reduction(tok.location(), "template-bind"));
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

