/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.ReturnParser;
import org.flasck.flas.parser.StructFieldConsumer;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAProvideType;
import org.flasck.flas.parser.TypeExprParser;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDAStructFieldParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final StructFieldConsumer builder;
    private final FieldsDefn.FieldsType fieldsType;
    private final boolean createAsAccessors;
    private final LocationTracker locTracker;

    public TDAStructFieldParser(ErrorReporter errors, StructFieldConsumer builder, FieldsDefn.FieldsType fieldsType, boolean createAsAccessors, LocationTracker locTracker) {
        this.errors = errors;
        this.builder = builder;
        this.fieldsType = fieldsType;
        this.createAsAccessors = createAsAccessors;
        this.locTracker = locTracker;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        ValidIdentifierToken field;
        InputPosition startLine = toks.realinfo();
        TypeReference type = null;
        if (this.fieldsType != FieldsDefn.FieldsType.WRAPS) {
            TypeExprParser parser = new TypeExprParser(this.errors);
            ArrayList types = new ArrayList();
            TDAProvideType pt = ty -> types.add(ty);
            parser.tryParsing(toks, pt);
            if (types.isEmpty()) {
                this.errors.message(toks, "field must have a valid type definition");
                return new IgnoreNestedParser(this.errors);
            }
            type = (TypeReference)types.get(0);
        }
        if ((field = VarNameToken.from(this.errors, toks)) == null) {
            this.errors.message(toks, "field must have a valid field name");
            return new IgnoreNestedParser(this.errors);
        }
        if (field.text.equals("id")) {
            this.errors.message(toks, "'id' is a reserved field name");
            return new IgnoreNestedParser(this.errors);
        }
        ErrorMark m = this.errors.mark();
        ReturnParser ret = new ReturnParser(this.errors);
        if (!toks.hasMoreContent(this.errors)) {
            if (this.fieldsType == FieldsDefn.FieldsType.WRAPS) {
                this.errors.message(toks, "wraps fields must have initializers");
                return new IgnoreNestedParser(this.errors);
            }
            this.errors.logReduction("struct-field-no-initialization", startLine, toks.realinfo());
            if (this.locTracker != null) {
                this.locTracker.updateLoc(startLine);
            }
            this.builder.addField(new StructField(field.location, this.builder.holder(), this.createAsAccessors, true, type, field.text));
            ret.noNest(this.errors);
        } else {
            if (this.fieldsType == FieldsDefn.FieldsType.ENVELOPE) {
                this.errors.message(toks, "envelope fields may not have initializers");
                return new IgnoreNestedParser(this.errors);
            }
            toks.skipWS(this.errors);
            ExprToken arrow = ExprToken.from(this.errors, toks);
            if (!"<-".equals(arrow.text)) {
                this.errors.message(toks, "expected <- or end of line");
                return new IgnoreNestedParser(this.errors);
            }
            TypeReference ft = type;
            new TDAExpressionParser(this.errors, expr -> {
                if (m.hasMoreNow()) {
                    ret.ignore();
                } else {
                    ret.noNest(this.errors);
                    if (this.locTracker != null) {
                        this.locTracker.updateLoc(startLine);
                    }
                    this.errors.logReduction("struct-initializer", arrow.location, toks.realinfo());
                    this.errors.logReduction("struct-field-with-initialization", startLine, arrow.location);
                    this.builder.addField(new StructField(field.location, arrow.location, this.builder.holder(), this.createAsAccessors, true, ft, field.text, (Expr)expr));
                }
            }).tryParsing(toks);
            if (toks.hasMoreContent(this.errors)) {
                this.errors.message(toks, "invalid tokens after expression");
            }
            if (this.errors.hasErrors()) {
                return new IgnoreNestedParser(this.errors);
            }
        }
        return ret.get();
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

