/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parser.ExprTermConsumer;
import org.flasck.flas.parser.Punctuator;
import org.flasck.flas.parser.StackDumper;
import org.flasck.flas.parser.TDAExprReducer;
import org.zinutils.exceptions.NotImplementedException;

public class TDAStackReducer
implements ExprTermConsumer {
    private final ErrorReporter errors;
    private final List<ExprTermConsumer> stack = new ArrayList<ExprTermConsumer>();
    private final ErrorMark mark;
    private InputPosition lineStart;

    public TDAStackReducer(ErrorReporter errors, ExprTermConsumer builder) {
        this(errors, builder, true);
    }

    public TDAStackReducer(ErrorReporter errors, ExprTermConsumer builder, boolean reduceToOne) {
        this.errors = errors;
        this.stack.add(new TDAExprReducer(errors, builder, reduceToOne));
        this.mark = errors.mark();
    }

    @Override
    public boolean isTop() {
        return this.stack.size() == 1;
    }

    @Override
    public void term(Expr term) {
        if (this.lineStart == null) {
            this.lineStart = term.location();
        }
        if (term instanceof Punctuator) {
            Punctuator punc = (Punctuator)term;
            if (punc.is("(")) {
                this.stack.add(0, punc.openParenParser(this.errors, new ParentConsumer()));
                return;
            }
            if (punc.is("[")) {
                this.stack.add(0, punc.openSquareParser(this.errors, new ParentConsumer()));
                return;
            }
            if (punc.is("{")) {
                this.stack.add(0, punc.openCurlyParser(this.errors, new ParentConsumer()));
                return;
            }
        }
        this.stack.get(0).term(term);
    }

    @Override
    public void done() {
        if (this.stack.size() != 1) {
            if (!this.mark.hasMoreNow()) {
                this.errors.message(this.lineStart, "syntax error");
            }
            return;
        }
        this.stack.remove(0).done();
    }

    @Override
    public void showStack(StackDumper d) {
        d.levels(this.stack.size());
        for (int i = this.stack.size() - 1; i >= 0; --i) {
            this.stack.get(i).showStack(d.indent(this.stack.size() - i));
        }
    }

    public class ParentConsumer
    implements ExprTermConsumer {
        @Override
        public boolean isTop() {
            return TDAStackReducer.this.stack.size() == 1;
        }

        @Override
        public void term(Expr term) {
            TDAStackReducer.this.stack.remove(0);
            if (TDAStackReducer.this.stack.isEmpty()) {
                throw new RuntimeException("Stack underflow - should be error");
            }
            TDAStackReducer.this.stack.get(0).term(term);
        }

        @Override
        public void done() {
            throw new NotImplementedException();
        }

        @Override
        public void showStack(StackDumper d) {
        }
    }
}

