/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.names.CSName;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.MethodConsumer;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.ServiceElementsConsumer;
import org.flasck.flas.parser.TDAImplementationMethodsParser;
import org.flasck.flas.parser.TDAMethodParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDAServiceElementsParser
extends BlockLocationTracker
implements TDAParsing {
    private final TemplateNamer namer;
    private final ServiceElementsConsumer consumer;
    private final TopLevelDefinitionConsumer topLevel;
    private final ServiceElementsConsumer service;

    public TDAServiceElementsParser(ErrorReporter errors, TemplateNamer namer, ServiceElementsConsumer service, TopLevelDefinitionConsumer topLevel, LocationTracker tracker) {
        super(errors, tracker);
        this.namer = namer;
        this.service = service;
        this.consumer = service;
        this.topLevel = topLevel;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        if (kw == null) {
            return null;
        }
        switch (kw.text) {
            case "state": {
                this.errors.message(kw.location, "services may not have state");
                return new IgnoreNestedParser(this.errors);
            }
            case "implements": {
                this.errors.message(kw.location, "services may not implement down contracts");
                return new IgnoreNestedParser(this.errors);
            }
            case "method": {
                FunctionNameProvider namer = (loc, text) -> FunctionName.standaloneMethod(loc, this.consumer.cardName(), text);
                MethodConsumer smConsumer = sm -> this.topLevel.newStandaloneMethod(this.errors, new StandaloneMethod(sm));
                return new TDAMethodParser(this.errors, this.namer, smConsumer, this.topLevel, null, this, null, null, false).parseMethod(kw, namer, toks);
            }
            case "provides": {
                TypeNameToken tn = TypeNameToken.qualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid contract reference");
                    return new IgnoreNestedParser(this.errors);
                }
                InputPosition varloc = null;
                String varname = null;
                if (toks.hasMoreContent(this.errors)) {
                    ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
                    if (var == null) {
                        this.errors.message(toks, "invalid service var name");
                        return new IgnoreNestedParser(this.errors);
                    }
                    varloc = var.location;
                    varname = var.text;
                    this.updateLoc(varloc);
                    this.errors.logReduction("provides-contract-name-with-var", kw.location, varloc);
                } else {
                    this.updateLoc(tn.location);
                    this.errors.logReduction("provides-contract-name", kw.location, tn.location);
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra tokens at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                TypeReference ctr = this.namer.contract(tn.location, tn.text);
                CSName csn = this.namer.csn(tn.location, "S");
                Provides cs = new Provides(kw.location, tn.location, this.service, ctr, csn, varloc, varname);
                this.consumer.addProvidedService(cs);
                if (varname != null) {
                    this.topLevel.newProvidesServiceWithName(this.errors, cs);
                }
                return new TDAParsingWithAction(new TDAImplementationMethodsParser(this.errors, (loc, text) -> FunctionName.contractMethod(loc, csn, text), cs, this.topLevel, null, this), this.reduction(kw.location, "provides-contract"));
            }
            case "requires": {
                TypeNameToken tn = TypeNameToken.qualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid contract reference");
                    return new IgnoreNestedParser(this.errors);
                }
                InputPosition lastLoc = tn.location;
                InputPosition varloc = null;
                String varname = null;
                if (toks.hasMoreContent(this.errors)) {
                    ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
                    if (var == null) {
                        this.errors.message(toks, "invalid service var name");
                        return new IgnoreNestedParser(this.errors);
                    }
                    varloc = var.location;
                    varname = var.text;
                    lastLoc = varloc;
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra tokens at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                TypeReference ctr = this.namer.contract(tn.location, tn.text);
                CSName cin = this.namer.csn(tn.location, "R");
                RequiresContract rc = new RequiresContract(kw.location, tn.location, this.consumer, ctr, cin, varloc, varname);
                this.consumer.addRequiredContract(rc);
                this.topLevel.newRequiredContract(this.errors, rc);
                this.errors.logReduction("requires-contract", kw.location, lastLoc);
                this.tellParent(tn.location);
                return new NoNestingParser(this.errors);
            }
        }
        return null;
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

