/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ConstPattern;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.compiler.DuplicateNameException;
import org.flasck.flas.compiler.StateNameException;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ConstructorMatch;
import org.flasck.flas.parsedForm.TuplePattern;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDATypeReferenceParser;
import org.flasck.flas.parser.VarNamer;
import org.flasck.flas.tokenizers.PattToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;

public class TDAPatternParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final VarNamer namer;
    private final Consumer<Pattern> consumer;
    private final FunctionScopeUnitConsumer topLevel;

    public TDAPatternParser(ErrorReporter errors, VarNamer namer, Consumer<Pattern> consumer, FunctionScopeUnitConsumer topLevel) {
        this.errors = errors;
        this.namer = namer;
        this.consumer = consumer;
        this.topLevel = topLevel;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        return this.tryParsing(toks, this.errors.mark());
    }

    public TDAParsing tryParsing(Tokenizable toks, ErrorMark currErr) {
        if (currErr.hasMoreNow()) {
            return null;
        }
        TypeNameToken qn = TypeNameToken.qualified(this.errors, toks);
        if (qn != null) {
            return this.handleASimpleConstructor(qn);
        }
        PattToken initial = PattToken.from(this.errors, toks);
        if (initial == null) {
            return null;
        }
        switch (initial.type) {
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return this.handleConst(initial);
            }
            case 1: {
                return this.handleASimpleVar(initial);
            }
            case 2: {
                throw new RuntimeException("Should have matched above");
            }
            case 10: {
                return this.handleORBCases(initial, toks);
            }
            case 12: {
                return this.handleListCases(initial, toks);
            }
        }
        return this.invalidPattern(toks);
    }

    public TDAParsing handleORBCases(PattToken orb, Tokenizable toks) {
        PattToken crb;
        ArrayList tuples;
        block12: {
            tuples = new ArrayList();
            TDAPatternParser delegate = new TDAPatternParser(this.errors, this.namer, patt -> tuples.add(patt), this.topLevel);
            do {
                TDAParsing success;
                if ((success = delegate.handleOneORBMemberCase(toks)) == null) {
                    return null;
                }
                crb = PattToken.from(this.errors, toks);
                if (crb == null) {
                    return this.invalidPattern(toks);
                }
                if (crb.type == 11) break block12;
            } while (crb.type == 17);
            return this.invalidPattern(toks);
        }
        if (tuples.isEmpty()) {
            return this.invalidPattern(toks);
        }
        if (tuples.size() == 1) {
            Pattern arg = (Pattern)tuples.get(0);
            if (arg instanceof TypedPattern) {
                this.errors.logReduction("argument-pattern-typed", orb.location, crb.location);
            } else if (arg instanceof ConstructorMatch) {
                ConstructorMatch cm = (ConstructorMatch)arg;
                if (cm.args.isEmpty()) {
                    this.errors.logReduction("argument-pattern-ctor-trivial", orb.location, crb.location);
                } else {
                    this.errors.logReduction("argument-pattern-ctor-fields", orb.location, crb.location);
                }
            } else {
                this.errors.logReduction("pattern-other-orb-case", orb.location, crb.location);
            }
            this.consumer.accept(((Pattern)tuples.get(0)).locatedAt(orb.location.copySetEnd(crb.location.off)));
        } else {
            this.errors.logReduction("pattern-tuples-case", orb.location, crb.location);
            this.consumer.accept(new TuplePattern(orb.location.copySetEnd(crb.location.off), tuples));
        }
        return this;
    }

    public TDAParsing handleOneORBMemberCase(Tokenizable toks) {
        int mark = toks.at();
        TypeNameToken qn = TypeNameToken.qualified(this.errors, toks);
        if (qn != null) {
            toks.reset(mark);
            return this.handleCasesStartingWithAType(toks, qn);
        }
        PattToken inside = PattToken.from(this.errors, toks);
        if (inside == null) {
            return this.invalidPattern(toks);
        }
        switch (inside.type) {
            case 3: 
            case 5: 
            case 6: {
                return this.handleConst(inside);
            }
            case 1: {
                return this.handleASimpleVar(inside);
            }
            case 2: {
                throw new RuntimeException("should be handled above");
            }
        }
        return this.invalidPattern(toks);
    }

    private TDAParsing handleConst(PattToken constant) {
        switch (constant.type) {
            case 3: {
                this.consumer.accept(new ConstPattern(constant.location, 1, constant.text));
                return this;
            }
            case 4: {
                this.consumer.accept(new ConstPattern(constant.location, 3, constant.text));
                return this;
            }
            case 5: 
            case 6: {
                this.consumer.accept(new ConstPattern(constant.location, 2, constant.text));
                return this;
            }
        }
        throw new RuntimeException("type " + constant.type + " should not come here and not be handled");
    }

    public TDAParsing handleASimpleVar(PattToken initial) {
        VarPattern vp = new VarPattern(initial.location, this.namer.nameVar(initial.location, initial.text));
        this.consumer.accept(vp);
        try {
            this.topLevel.argument(null, vp);
        }
        catch (DuplicateNameException ex) {
            this.errors.message(vp.location(), "duplicate function argument " + vp.var);
        }
        catch (StateNameException ex) {
            this.errors.message(vp.location(), "cannot use " + vp.var + " as function argument because is a state member at " + ex.location());
        }
        return this;
    }

    public TDAParsing handleASimpleConstructor(TypeNameToken type) {
        this.consumer.accept(new ConstructorMatch(type.location, type.text));
        return this;
    }

    public TDAParsing handleCasesStartingWithAType(Tokenizable toks, TypeNameToken type) {
        ArrayList ref = new ArrayList();
        if (new TDATypeReferenceParser(this.errors, this.namer, true, x -> ref.add(x), this.topLevel).tryParsing(toks) == null) {
            return null;
        }
        TypeReference tr = (TypeReference)ref.get(0);
        int beforeChecking = toks.at();
        PattToken tok = PattToken.from(this.errors, toks);
        if (tok.type == 1) {
            TypedPattern m = new TypedPattern(type.location, tr, this.namer.nameVar(tok.location, tok.text));
            this.consumer.accept(m);
            this.topLevel.argument(this.errors, m);
            return this;
        }
        if (tr.hasPolys()) {
            this.errors.message(toks, "type parameters can only be used with type patterns");
            return null;
        }
        if (tok.type == 14) {
            return this.handleAConstructorMatch(type, toks);
        }
        if (tok.type == 11) {
            toks.reset(beforeChecking);
            return this.handleASimpleConstructor(type);
        }
        return this.invalidPattern(toks);
    }

    public TDAParsing handleAConstructorMatch(TypeNameToken type, Tokenizable toks) {
        ConstructorMatch m = new ConstructorMatch(type.location, type.text);
        PattToken comma = null;
        while (true) {
            PattToken ccb;
            PattToken fld;
            if ((fld = PattToken.from(this.errors, toks)) == null) {
                return this.invalidPattern(toks);
            }
            if (fld.type == 15) break;
            if (fld.type != 1) {
                return this.invalidPattern(toks);
            }
            PattToken colon = PattToken.from(this.errors, toks);
            if (colon == null || colon.type != 16) {
                return this.invalidPattern(toks);
            }
            TDAParsing success = new TDAPatternParser(this.errors, this.namer, patt -> {
                this.errors.logReduction("field-argument-pattern", fld, (Locatable)patt);
                List<ConstructorMatch.Field> list = m.args;
                ConstructorMatch constructorMatch = m;
                Objects.requireNonNull(constructorMatch);
                list.add(constructorMatch.new ConstructorMatch.Field(fld.location, fld.text, (Pattern)patt));
            }, this.topLevel).tryParsing(toks);
            if (success == null) {
                return null;
            }
            if (comma != null) {
                this.errors.logReduction("comma-field-argument-pattern", comma, fld);
            }
            if ((ccb = PattToken.from(this.errors, toks)) == null) {
                return this.invalidPattern(toks);
            }
            if (ccb.type == 15) break;
            if (ccb.type != 17) {
                return this.invalidPattern(toks);
            }
            comma = ccb;
        }
        this.consumer.accept(m);
        return this;
    }

    private TDAParsing handleListCases(PattToken osb, Tokenizable toks) {
        PattToken csb;
        ArrayList members;
        block7: {
            PattToken comma;
            members = new ArrayList();
            TDAPatternParser inner = new TDAPatternParser(this.errors, this.namer, patt -> members.add(0, patt), this.topLevel);
            csb = null;
            do {
                int from = toks.at();
                PattToken nx = PattToken.from(this.errors, toks);
                if (nx.type == 13) {
                    csb = nx;
                } else {
                    toks.reset(from);
                    if (inner.tryParsing(toks) == null) {
                        return null;
                    }
                    comma = PattToken.from(this.errors, toks);
                    if (comma.type != 13) continue;
                    csb = comma;
                }
                break block7;
            } while (comma.type == 17);
            return this.invalidPattern(toks);
        }
        ConstructorMatch ret = new ConstructorMatch(osb.location, "Nil");
        while (!members.isEmpty()) {
            Pattern m = (Pattern)members.remove(0);
            ConstructorMatch prev = ret;
            ret = new ConstructorMatch(osb.location, "Cons");
            List<ConstructorMatch.Field> list = ret.args;
            ConstructorMatch constructorMatch = ret;
            Objects.requireNonNull(constructorMatch);
            list.add(constructorMatch.new ConstructorMatch.Field(m.location(), "head", m));
            List<ConstructorMatch.Field> list2 = ret.args;
            ConstructorMatch constructorMatch2 = ret;
            Objects.requireNonNull(constructorMatch2);
            list2.add(constructorMatch2.new ConstructorMatch.Field(ret.location(), "tail", prev));
        }
        if (ret.args.isEmpty()) {
            this.errors.logReduction("pattern-empty-list", osb, csb);
        } else {
            this.errors.logReduction("pattern-non-empty-list", osb, csb);
        }
        this.consumer.accept(ret);
        return this;
    }

    public TDAParsing invalidPattern(Tokenizable toks) {
        this.errors.message(toks, "invalid pattern");
        return null;
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

