/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateEvent;
import org.flasck.flas.parsedForm.TemplateField;
import org.flasck.flas.parsedForm.TemplateReference;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.RequireEventsParser;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDATemplateOptionsParser;
import org.flasck.flas.parser.TDATemplateStylingParser;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.TemplateNameToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDAParseTemplateElements {
    public static TDAParsing parseConditionalBindingOption(ErrorReporter errors, InputPosition barPos, Template source, TemplateNamer namer, Tokenizable toks, TemplateField field, Consumer<TemplateBindingOption> consumer, LocationTracker tracker) {
        ArrayList seen = new ArrayList();
        new TDAExpressionParser(errors, t -> seen.add(t)).tryParsing(toks);
        ExprToken tok = ExprToken.from(errors, toks);
        if (tok == null) {
            errors.message(toks, "syntax error");
            return new IgnoreNestedParser(errors);
        }
        if ("<-".equals(tok.text)) {
            if (seen.isEmpty()) {
                errors.message(toks, "no conditional expression");
                return new IgnoreNestedParser(errors);
            }
            TemplateBindingOption tbo = TDAParseTemplateElements.readTemplateBinding(errors, namer, toks, field);
            if (tbo == null) {
                return new IgnoreNestedParser(errors);
            }
            TemplateBindingOption tc = tbo.conditionalOn(barPos, (Expr)seen.get(0));
            consumer.accept(tc);
            errors.logReduction("template-conditional-binding", barPos, tbo.location());
            if (tracker != null) {
                tracker.updateLoc(barPos);
            }
            return new TDAParsingWithAction(new TDATemplateOptionsParser(errors, source, namer, tc, field, tracker), () -> errors.logReduction("option-template-bind", barPos, tracker.lastInner()));
        }
        errors.message(toks, "syntax error");
        return new IgnoreNestedParser(errors);
    }

    public static TDAParsing parseDefaultBindingOption(ErrorReporter errors, InputPosition sendPos, Template source, TemplateNamer namer, Tokenizable toks, TemplateField field, Consumer<TemplateBindingOption> consumer, LocationTracker tracker) {
        TemplateBindingOption tc = TDAParseTemplateElements.readTemplateBinding(errors, namer, toks, field);
        if (tc == null) {
            return new IgnoreNestedParser(errors);
        }
        consumer.accept(tc);
        if (tc.sendsTo != null) {
            errors.logReduction("template-default-binding-with-send", sendPos, tc.location());
        } else {
            errors.logReduction("template-default-binding", sendPos, tc.location());
        }
        if (tracker != null) {
            tracker.updateLoc(sendPos);
        }
        return new TDAParsingWithAction(new TDATemplateOptionsParser(errors, source, namer, tc, field, tracker), () -> errors.logReduction("default-option-template-bind", sendPos, tracker.lastInner()));
    }

    public static TDAParsing parseStyling(ErrorReporter errors, InputPosition barPos, Template source, TemplateNamer namer, Tokenizable toks, Consumer<TemplateStylingOption> consumer, LocationTracker locTracker) {
        locTracker.updateLoc(barPos);
        ArrayList seen = new ArrayList();
        new TDAExpressionParser(errors, t -> seen.add(t)).tryParsing(toks);
        Expr expr = seen.size() == 0 ? null : (Expr)seen.get(0);
        ExprToken tok = ExprToken.from(errors, toks);
        BlockLocationTracker blt = new BlockLocationTracker(errors, locTracker);
        if (tok == null) {
            TemplateStylingOption tso = new TemplateStylingOption(barPos, expr, new ArrayList<Expr>(), null);
            consumer.accept(tso);
            errors.logReduction("template-conditional-styling-no-actions", barPos, expr.location());
            return new TDAParsingWithAction(new RequireEventsParser(errors, toks.realinfo(), source, namer, tso, blt), blt.reduction(barPos, "template-style-cond"));
        }
        if ("=>".equals(tok.text)) {
            TemplateStylingOption tso = TDAParseTemplateElements.readTemplateStyles(barPos, errors, expr, toks, blt);
            if (tso == null) {
                return new IgnoreNestedParser(errors);
            }
            consumer.accept(tso);
            if (tso.orelse != null) {
                errors.logReduction("template-style-format-or-else", barPos, tso.orelse.get(tso.orelse.size() - 1).location());
                return new NoNestingParser(errors, "cannot nest more options inside a cond-or-else style");
            }
            return new TDAParsingWithAction(new TDATemplateStylingParser(errors, source, namer, tso, blt), blt.reduction(barPos, "template-style-format"));
        }
        errors.message(toks, "=> required for styling");
        return new IgnoreNestedParser(errors);
    }

    public static TDAParsing parseEventHandling(ExprToken arrow, ErrorReporter errors, Template source, Tokenizable toks, Consumer<TemplateEvent> consumer, LocationTracker locTracker) {
        ExprToken tok = ExprToken.from(errors, toks);
        if (tok == null) {
            errors.message(toks, "event handler name required");
            return new IgnoreNestedParser(errors);
        }
        if (tok.type != 1) {
            errors.message(tok.location, "event handler name required");
            return new IgnoreNestedParser(errors);
        }
        if (toks.hasMoreContent(errors)) {
            errors.message(toks, "surplus text at end of line");
            return new IgnoreNestedParser(errors);
        }
        TemplateEvent ev = new TemplateEvent(tok.location, tok.text, source);
        consumer.accept(ev);
        errors.logReduction("template-event", arrow.location, tok.location);
        locTracker.updateLoc(arrow.location);
        return new NoNestingParser(errors);
    }

    public static TemplateBindingOption readTemplateBinding(ErrorReporter errors, TemplateNamer namer, Tokenizable toks, TemplateField field) {
        ExprToken sendToTok;
        ArrayList seen = new ArrayList();
        new TDAExpressionParser(errors, t -> seen.add(t)).tryParsing(toks);
        if (seen.isEmpty()) {
            errors.message(toks, "no expression to send");
            return null;
        }
        TemplateReference sendTo = null;
        if (toks.hasMoreContent(errors) && (sendToTok = ExprToken.from(errors, toks)) != null) {
            if ("=>".equals(sendToTok.text)) {
                TemplateNameToken tnt = TemplateNameToken.from(errors, toks);
                sendTo = new TemplateReference(tnt.location, namer.template(tnt.location, tnt.text));
            } else {
                errors.message(toks, "syntax error");
                return null;
            }
        }
        if (toks.hasMoreContent(errors)) {
            errors.message(toks, "syntax error");
            return null;
        }
        return new TemplateBindingOption(((Expr)seen.get(0)).location(), field, null, (Expr)seen.get(0), sendTo);
    }

    public static TemplateStylingOption readTemplateStyles(InputPosition barPos, ErrorReporter errors, Expr expr, Tokenizable toks, LocationTracker locTracker) {
        ArrayList<Expr> styles = new ArrayList<Expr>();
        ArrayList orelse = null;
        ArrayList<Expr> addTo = styles;
        InputPosition lastLoc = barPos;
        String opt = "";
        if (expr != null) {
            lastLoc = expr.location();
            opt = "-with-guard";
        }
        while (toks.hasMoreContent(errors)) {
            int mark = toks.at();
            ExprToken et = ExprToken.from(errors, toks);
            if (et != null) {
                lastLoc = et.location;
                if (et.type == 1) {
                    addTo.add(new UnresolvedVar(et.location, et.text));
                    errors.logReduction("function-call", et.location, et.location.locAtEnd());
                    continue;
                }
                if (et.type == 5) {
                    addTo.add(new StringLiteral(et.location, et.text));
                    continue;
                }
                if (et.type == 4) {
                    if (et.text.equals("||")) {
                        opt = "-with-or";
                        if (expr == null) {
                            errors.message(et.location, "cannot use || without a condition");
                            return null;
                        }
                        if (orelse != null) {
                            errors.message(et.location, "cannot use || more than once");
                            return null;
                        }
                        orelse = new ArrayList();
                        addTo = orelse;
                        continue;
                    }
                } else if (et.type == 3 && et.text.equals("(")) {
                    toks.reset(mark);
                    final ArrayList ret = new ArrayList();
                    Consumer<Expr> handler = new Consumer<Expr>(){

                        @Override
                        public void accept(Expr t) {
                            ret.add(t);
                        }
                    };
                    TDAExpressionParser ep = new TDAExpressionParser(errors, handler);
                    ep.tryParsing(toks);
                    if (ret.size() != 1) {
                        errors.message(et.location, "valid style expected");
                        return null;
                    }
                    addTo.add((Expr)ret.get(0));
                    continue;
                }
                errors.message(et.location, "valid style expected");
                return null;
            }
            errors.message(toks, "valid style expected");
            return null;
        }
        errors.logReduction("template-conditional-styling" + opt, barPos, lastLoc);
        if (locTracker != null) {
            locTracker.updateLoc(barPos);
        }
        return new TemplateStylingOption(barPos, expr, styles, orelse);
    }
}

