/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.ObjectAccessor;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.CaptureFunctionDefinition;
import org.flasck.flas.parser.ConsumeStructFields;
import org.flasck.flas.parser.FunctionAssembler;
import org.flasck.flas.parser.FunctionDefnConsumer;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LastActionScopeParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.MethodConsumer;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.ObjectElementsConsumer;
import org.flasck.flas.parser.PackageNamer;
import org.flasck.flas.parser.SimpleVarNamer;
import org.flasck.flas.parser.TDACardElementsParser;
import org.flasck.flas.parser.TDAFunctionParser;
import org.flasck.flas.parser.TDAMethodGuardParser;
import org.flasck.flas.parser.TDAMethodParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAPatternParser;
import org.flasck.flas.parser.TDAStructFieldParser;
import org.flasck.flas.parser.TDATemplateBindingParser;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.resolver.NestingChain;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.TemplateNameToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDAObjectElementsParser
extends BlockLocationTracker
implements TDAParsing {
    private final TemplateNamer namer;
    private final ObjectElementsConsumer builder;
    private final TopLevelDefinitionConsumer topLevel;

    public TDAObjectElementsParser(ErrorReporter errors, TemplateNamer namer, ObjectElementsConsumer od, TopLevelDefinitionConsumer topLevel, LocationTracker locTracker) {
        super(errors, locTracker);
        this.namer = namer;
        this.builder = od;
        this.topLevel = topLevel;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        if (kw == null) {
            return null;
        }
        this.updateLoc(kw.location);
        switch (kw.text) {
            case "state": {
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra characters at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                StateDefinition state = new StateDefinition(kw.location, toks.realinfo(), this.builder.name());
                this.builder.defineState(state);
                this.errors.logReduction("state-line", kw.location, kw.location.locAtEnd());
                this.tellParent(kw.location);
                return new TDAParsingWithAction(new TDAStructFieldParser(this.errors, new ConsumeStructFields(this.errors, this.topLevel, this.namer, state), FieldsDefn.FieldsType.STATE, false, this), this.reduction(kw.location, "state-declaration"));
            }
            case "requires": {
                TypeNameToken tn = TypeNameToken.qualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid contract reference");
                    return new IgnoreNestedParser(this.errors);
                }
                if (!toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "missing variable name");
                    return new IgnoreNestedParser(this.errors);
                }
                ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
                if (var == null) {
                    this.errors.message(toks, "invalid service var name");
                    return new IgnoreNestedParser(this.errors);
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra tokens at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                TypeReference ctr = this.namer.contract(tn.location, tn.text);
                VarName cv = this.namer.nameVar(var.location, var.text);
                ObjectContract oc = new ObjectContract(var.location, ctr, cv);
                this.builder.requireContract(oc);
                this.topLevel.newObjectContract(this.errors, oc);
                this.errors.logReduction("requires-contract", kw.location, var.location);
                this.tellParent(kw.location);
                return new NoNestingParser(this.errors);
            }
            case "template": {
                TemplateNameToken tn = TemplateNameToken.from(this.errors, toks);
                InputPosition lastPos = tn.location;
                ErrorMark em2 = this.errors.mark();
                int pos2 = this.builder.templatePosn();
                NestingChain chain = null;
                if (toks.hasMoreContent(this.errors)) {
                    chain = TDACardElementsParser.parseChain(this.errors, this.namer, toks);
                }
                if (em2.hasMoreNow()) {
                    return new IgnoreNestedParser(this.errors);
                }
                if (chain != null) {
                    lastPos = chain.location();
                }
                Template template = new Template(kw.location, tn.location, this.namer.template(tn.location, tn.text), pos2, chain);
                this.builder.addTemplate(template);
                this.topLevel.newTemplate(this.errors, template);
                if (chain != null && !chain.isEmpty()) {
                    this.errors.logReduction("template-introduction-with-chain", kw.location, lastPos);
                } else {
                    this.errors.logReduction("template-introduction", kw.location, lastPos);
                }
                this.tellParent(kw.location);
                return new TDAParsingWithAction(new TDATemplateBindingParser(this.errors, template, this.namer, template, this), this.reduction(kw.location, "named-template-definition"));
            }
            case "event": {
                FunctionNameProvider namer = (loc, text) -> FunctionName.eventMethod(loc, this.builder.name(), text);
                MethodConsumer evConsumer = em -> {
                    if (em.args().size() != 1) {
                        this.errors.message(toks, "event handlers must have exactly one (typed) argument");
                        return;
                    }
                    Pattern ev = em.args().get(0);
                    if (ev instanceof VarPattern) {
                        this.errors.message(ev.location(), "event arguments must be typed");
                        return;
                    }
                    em.eventFor((ObjectDefn)this.builder);
                    ev.isDefinedBy(em);
                    this.builder.addEventHandler(em);
                    this.topLevel.newObjectMethod(this.errors, em);
                };
                this.tellParent(kw.location);
                TDAMethodParser np = new TDAMethodParser(this.errors, this.namer, evConsumer, this.topLevel, (StateHolder)((Object)this.builder), this, null, "event-from-method", false);
                return new TDAParsingWithAction(np.parseMethod(kw, namer, toks), np.reduction(kw.location, "event-handler"));
            }
            case "ctor": {
                ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
                FunctionName fnName = this.namer.ctor(var.location, var.text);
                InputPosition lastLoc = fnName.location;
                ArrayList args = new ArrayList();
                TDAPatternParser pp = new TDAPatternParser(this.errors, new SimpleVarNamer(fnName), p -> args.add(p), this.topLevel);
                while (pp.tryParsing(toks) != null) {
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra characters at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                ObjectCtor ctor = new ObjectCtor(var.location, this.builder, fnName, args){

                    @Override
                    public void done() {
                        super.done();
                        TDAObjectElementsParser.this.topLevel.newObjectMethod(TDAObjectElementsParser.this.errors, this);
                    }
                };
                for (Pattern p2 : args) {
                    p2.isDefinedBy(ctor);
                    lastLoc = p2.location();
                }
                this.builder.addConstructor(ctor);
                this.errors.logReduction("method-intro", var.location, lastLoc);
                this.errors.logReduction("object-ctor-decl", kw.location, lastLoc);
                this.tellParent(kw.location);
                PackageNamer ctorNamer = new PackageNamer(fnName);
                return new TDAParsingWithAction(new TDAMethodGuardParser(this.errors, ctor, new LastActionScopeParser(this.errors, ctorNamer, this.topLevel, "action", (StateHolder)((Object)this.builder), this), this), () -> {
                    if (!ctor.messages().isEmpty()) {
                        this.reduce(ctor.messages().get(0).location(), "method-actions");
                    }
                    this.reduce(kw.location, "object-ctor-definition");
                });
            }
            case "acor": {
                FunctionDefnConsumer consumer = (errors, f) -> {
                    ObjectAccessor oa = new ObjectAccessor((StateHolder)((Object)this.builder), f);
                    f.isObjAccessor(true);
                    this.builder.addAccessor(oa);
                    this.topLevel.newObjectAccessor(errors, oa);
                    errors.logReduction("object-acor-decl", kw.location, f.location());
                };
                toks.skipWS(this.errors);
                this.tellParent(kw.location);
                FunctionAssembler fa = new FunctionAssembler(this.errors, new CaptureFunctionDefinition(this.topLevel, consumer), (StateHolder)((Object)this.builder), this);
                TDAFunctionParser fcp = new TDAFunctionParser(this.errors, this.namer, (pos, x, cn) -> this.namer.functionCase(pos, x, cn), fa, this.topLevel, (StateHolder)((Object)this.builder), fa);
                TDAParsing ret = fcp.tryParsing(toks);
                if (ret == null) {
                    return null;
                }
                return new TDAParsingWithAction(ret, () -> {
                    fa.moveOn();
                    this.reduce(kw.location, "object-acor-definition");
                });
            }
            case "method": {
                FunctionNameProvider methodNamer = (loc, text) -> this.namer.method(loc, text);
                MethodConsumer dispenser = method -> {
                    this.builder.addMethod(method);
                    this.topLevel.newObjectMethod(this.errors, method);
                };
                this.tellParent(kw.location);
                TDAMethodParser mp = new TDAMethodParser(this.errors, this.namer, dispenser, this.topLevel, (StateHolder)((Object)this.builder), this, "method-intro", "object-method-intro", false);
                return new TDAParsingWithAction(mp.parseMethod(kw, methodNamer, toks), mp.reduction(kw.location, "object-method-definition"));
            }
        }
        return null;
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

