/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.ut.GuardedMessages;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.FunctionIntroConsumer;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.FunctionScopeNamer;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.InnerPackageNamer;
import org.flasck.flas.parser.LastActionScopeParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.MethodConsumer;
import org.flasck.flas.parser.SimpleVarNamer;
import org.flasck.flas.parser.TDAMethodGuardParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAPatternParser;
import org.flasck.flas.stories.TDAParserConstructor;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDAMethodParser
extends BlockLocationTracker {
    private final MethodConsumer builder;
    private final FunctionScopeUnitConsumer topLevel;
    private final StateHolder holder;
    private final String reduceAs;
    private final String kwReduceAs;
    private final boolean standalone;

    public TDAMethodParser(ErrorReporter errors, FunctionScopeNamer namer, MethodConsumer builder, FunctionScopeUnitConsumer topLevel, StateHolder holder, LocationTracker locTracker, String reduceAs, String kwReduceAs, boolean standalone) {
        super(errors, locTracker);
        this.builder = builder;
        this.topLevel = topLevel;
        this.holder = holder;
        this.reduceAs = reduceAs;
        this.kwReduceAs = kwReduceAs;
        this.standalone = standalone;
    }

    public TDAParsing parseMethod(KeywordToken kw, FunctionNameProvider methodNamer, Tokenizable toks) {
        ErrorMark mark = this.errors.mark();
        ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
        if (var == null) {
            this.errors.message(toks, "no method name provided");
            return new IgnoreNestedParser(this.errors);
        }
        InputPosition endOf = var.location;
        FunctionName fnName = methodNamer.functionName(var.location, var.text);
        ArrayList<Pattern> args = new ArrayList<Pattern>();
        TDAPatternParser pp = new TDAPatternParser(this.errors, new SimpleVarNamer(fnName), p -> args.add((Pattern)p), this.topLevel);
        while (pp.tryParsing(toks) != null) {
        }
        if (mark.hasMoreNow()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "extra characters at end of line");
            return new IgnoreNestedParser(this.errors);
        }
        if (!args.isEmpty()) {
            endOf = ((Pattern)args.get(args.size() - 1)).location();
        }
        if (this.reduceAs != null) {
            this.errors.logReduction(this.reduceAs, var.location, endOf);
            this.tellParent(var.location);
            endOf = var.location;
        }
        if (kw != null && this.kwReduceAs != null) {
            this.errors.logReduction(this.kwReduceAs, kw.location, endOf);
            this.tellParent(kw.location);
        }
        ObjectMethod meth = new ObjectMethod(var.location, fnName, args, null, this.holder);
        this.builder.addMethod(meth);
        InnerPackageNamer nestedNamer = new InnerPackageNamer(fnName);
        TDAMethodGuardParser normal = new TDAMethodGuardParser(this.errors, meth, new LastActionScopeParser(this.errors, nestedNamer, this.topLevel, "action", this.holder, this), this);
        TDAParsingWithAction reducer = new TDAParsingWithAction(normal, () -> {
            if (!meth.messages().isEmpty()) {
                this.reduce(meth.messages().get(0).location(), "method-actions");
            } else if (!meth.guards.isEmpty()) {
                String def = "";
                if (((GuardedMessages)meth.guards.get((int)(meth.guards.size() - 1))).guard == null) {
                    def = "-with-default";
                }
                this.reduce(((GuardedMessages)meth.guards.get(0)).location(), "method-guard-list" + def);
            }
        });
        if (this.standalone) {
            return new TDAParsingWithAction(reducer, this.reduction(kw.location, "standalone-method-definition"));
        }
        return reducer;
    }

    public static TDAParserConstructor constructor(final FunctionScopeNamer namer, FunctionIntroConsumer sb, final FunctionScopeUnitConsumer topLevel, final StateHolder holder, final LocationTracker locTracker) {
        return new TDAParserConstructor(){

            @Override
            public TDAParsing construct(final ErrorReporter errors) {
                return new TDAParsing(){

                    @Override
                    public TDAParsing tryParsing(Tokenizable toks) {
                        KeywordToken kw = KeywordToken.from(errors, toks);
                        if (kw == null || !"method".equals(kw.text)) {
                            return null;
                        }
                        return new TDAMethodParser(errors, namer, m -> topLevel.newStandaloneMethod(errors, new StandaloneMethod(m)), topLevel, holder, locTracker, null, "method-intro", true).parseMethod(kw, namer, toks);
                    }

                    @Override
                    public void scopeComplete(InputPosition location) {
                    }
                };
            }
        };
    }
}

