/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.SendMessage;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LastOneOnlyNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.MethodMessagesConsumer;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDAMethodMessageParser
extends BlockLocationTracker
implements TDAParsing {
    protected final MethodMessagesConsumer builder;
    protected final LastOneOnlyNestedParser nestedParser;
    protected final BlockLocationTracker actionsTracker;

    public TDAMethodMessageParser(ErrorReporter errors, MethodMessagesConsumer builder, LastOneOnlyNestedParser nestedParser, LocationTracker locTracker, BlockLocationTracker actionsTracker) {
        super(errors, locTracker);
        this.builder = builder;
        this.nestedParser = nestedParser;
        this.actionsTracker = actionsTracker;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        this.nestedParser.anotherParent();
        this.nestedParser.bindLocationTracker(this);
        ExprToken tok = ExprToken.from(this.errors, toks);
        this.updateLoc(tok.location);
        if (this.actionsTracker != null && this.actionsTracker.lastInner() == null) {
            this.actionsTracker.updateLoc(tok.location);
        }
        if ("<-".equals(tok.text)) {
            return this.handleSend(tok, toks);
        }
        if (tok.type == 1) {
            return this.handleAssign(tok, toks);
        }
        this.errors.message(toks, "expected assign or send message");
        return new IgnoreNestedParser(this.errors);
    }

    /*
     * Enabled aggressive block sorting
     */
    private TDAParsing handleSend(Locatable arrowPos, Tokenizable toks) {
        SendMessage send;
        block11: {
            ArrayList seen = new ArrayList();
            Tokenizable ec = toks.copyTo("->");
            new TDAExpressionParser(this.errors, t -> {
                SendMessage msg = new SendMessage(arrowPos.location(), (Expr)t);
                seen.add(msg);
            }).tryParsing(ec);
            if (seen.isEmpty()) {
                this.errors.message(toks, "no expression to send");
                return new IgnoreNestedParser(this.errors);
            }
            send = (SendMessage)seen.get(0);
            Expr last = send.expr;
            if (ec != toks) {
                String handled = "";
                toks.reset(ec.at());
                ExprToken htok = ExprToken.from(this.errors, toks);
                if (htok.text.equals("->")) {
                    handled = "-handled";
                    Tokenizable handlerText = toks.copyTo("=>");
                    TDAParsing rp = new TDAExpressionParser(this.errors, t -> send.handlerExpr((Expr)t)).tryParsing(handlerText);
                    if (send.handlerExpr() == null) {
                        this.errors.message(htok.location, "no valid handler specified");
                        return rp;
                    }
                    last = send.handlerExpr();
                    this.errors.logReduction("maybe-handled", htok, ((SendMessage)seen.get(0)).handlerExpr());
                    toks.reset(handlerText.at());
                } else {
                    toks.reset(ec.at());
                }
                if (toks.hasMoreContent(this.errors)) {
                    ExprToken tok = ExprToken.from(this.errors, toks);
                    if (tok.type == 4 && tok.text.equals("=>")) {
                        new TDAExpressionParser(this.errors, t -> send.subscriberNameExpr((Expr)t)).tryParsing(toks);
                        if (toks.hasMoreContent(this.errors)) {
                            this.errors.message(toks, "syntax error");
                            return new IgnoreNestedParser(this.errors);
                        }
                        if (send.subscriberName() == null) {
                            this.errors.message(htok.location, "no valid subscription specified");
                            return new IgnoreNestedParser(this.errors);
                        }
                        this.errors.logReduction("maybe-subscribed", tok, send.subscriberName());
                        this.errors.logReduction("method-message-send" + handled + "-subscribed", arrowPos, tok);
                        break block11;
                    } else {
                        this.errors.message(toks, "syntax error");
                        return new IgnoreNestedParser(this.errors);
                    }
                }
                this.errors.logReduction("method-message-send" + handled, arrowPos, last);
            } else {
                this.errors.logReduction("method-message-send", arrowPos, last);
            }
        }
        this.builder.sendMessage(send);
        this.tellParent(arrowPos.location());
        return new TDAParsingWithAction(this.nestedParser, () -> this.tellParent(this.lastInner()));
    }

    private TDAParsing handleAssign(ExprToken tok, Tokenizable toks) {
        Expr slot = null;
        Locatable last = null;
        while (true) {
            UnresolvedVar var = new UnresolvedVar(tok.location, tok.text);
            if (slot == null) {
                slot = var;
                last = var;
            } else {
                slot = new MemberExpr(slot.location(), slot, var);
            }
            tok = ExprToken.from(this.errors, toks);
            if (tok == null) {
                this.errors.message(toks, "expected . or <-");
                return new IgnoreNestedParser(this.errors);
            }
            if (tok.type != 3 || !".".equals(tok.text)) break;
            ExprToken dot = tok;
            tok = ExprToken.from(this.errors, toks);
            if (tok == null || tok.type != 1) {
                this.errors.message(toks, "expected identifier");
                return new IgnoreNestedParser(this.errors);
            }
            this.errors.logReduction("member-path-apply", dot, tok);
            last = dot;
        }
        this.errors.logReduction("member-path", slot, last);
        if (!"<-".equals(tok.text)) {
            this.errors.message(tok.location, "expected <-");
            return new IgnoreNestedParser(this.errors);
        }
        InputPosition pos = tok.location;
        ArrayList seen = new ArrayList();
        Expr slotExpr = slot;
        new TDAExpressionParser(this.errors, t -> {
            seen.add(t);
            AssignMessage msg = new AssignMessage(pos, slotExpr, (Expr)t);
            this.builder.assignMessage(msg);
        }).tryParsing(toks);
        if (seen.isEmpty()) {
            this.errors.message(toks, "no expression to send");
            return new IgnoreNestedParser(this.errors);
        }
        this.errors.logReduction("assign-method-action", slot, (Locatable)seen.get(seen.size() - 1));
        this.tellParent(slot.location());
        return new TDAParsingWithAction(this.nestedParser, () -> this.tellParent(this.lastInner()));
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.builder.done();
    }
}

