/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.GuardedMessagesConsumer;
import org.flasck.flas.parsedForm.ut.GuardedMessages;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LastOneOnlyNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.MethodMessagesConsumer;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAMethodMessageParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDAMethodGuardParser
extends TDAMethodMessageParser
implements TDAParsing {
    private Mode mode = Mode.FIRST;
    private final GuardedMessagesConsumer consumer;
    private boolean firstGuard = true;
    private boolean seenDefault = false;

    public TDAMethodGuardParser(ErrorReporter errors, MethodMessagesConsumer builder, LastOneOnlyNestedParser nestedParser, LocationTracker locTracker) {
        super(errors, builder, nestedParser, locTracker, new BlockLocationTracker(errors, null));
        this.consumer = (GuardedMessagesConsumer)((Object)builder);
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        switch (this.mode) {
            case WANTGUARDS: {
                return this.parseGuard(toks);
            }
            case WANTMESSAGES: {
                return super.tryParsing(toks);
            }
        }
        if (toks.charAt(0) == '|') {
            this.mode = Mode.WANTGUARDS;
            return this.parseGuard(toks);
        }
        this.mode = Mode.WANTMESSAGES;
        return super.tryParsing(toks);
    }

    private TDAParsing parseGuard(Tokenizable toks) {
        ExprToken tok = ExprToken.from(this.errors, toks);
        this.updateLoc(tok.location);
        if (!"|".equals(tok.text)) {
            this.errors.message(tok.location, "guard expected");
            return new IgnoreNestedParser(this.errors);
        }
        if (!toks.hasMoreContent(this.errors)) {
            if (this.firstGuard) {
                this.errors.message(tok.location, "first guard cannot be default");
                return new IgnoreNestedParser(this.errors);
            }
            if (this.seenDefault) {
                this.errors.message(tok.location, "cannot provide two default guards");
                return new IgnoreNestedParser(this.errors);
            }
            GuardedMessages dgm = new GuardedMessages(tok.location, null);
            this.consumer.guard(dgm);
            this.errors.logReduction("method-guard-default-bar", tok.location, tok.location);
            this.tellParent(tok.location);
            this.seenDefault = true;
            return new TDAParsingWithAction(new TDAMethodMessageParser(this.errors, dgm, this.nestedParser, this, new BlockLocationTracker(this.errors, null)), this.reduction(tok.location, "method-guard-default"));
        }
        ArrayList seen = new ArrayList();
        new TDAExpressionParser(this.errors, t -> {
            GuardedMessages gm = new GuardedMessages(tok.location, (Expr)t);
            seen.add(gm);
            this.consumer.guard(gm);
        }).tryParsing(toks);
        if (seen.isEmpty()) {
            this.errors.message(toks, "no guard expression");
            return new IgnoreNestedParser(this.errors);
        }
        this.firstGuard = false;
        this.errors.logReduction("method-guard-with-cond", tok.location, ((GuardedMessages)seen.get((int)(seen.size() - 1))).guard.location());
        this.tellParent(tok.location);
        return new TDAParsingWithAction(new TDAMethodMessageParser(this.errors, (MethodMessagesConsumer)seen.get(0), this.nestedParser, this, new BlockLocationTracker(this.errors, null)), this.reduction(tok.location, "method-guard"));
    }

    static enum Mode {
        FIRST,
        WANTGUARDS,
        WANTMESSAGES;

    }
}

