/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.names.CardName;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.HandlerName;
import org.flasck.flas.commonBase.names.ObjectName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AgentDefinition;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.ServiceDefinition;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.UnionTypeDefn;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.ConsumeStructFields;
import org.flasck.flas.parser.ContractMethodParser;
import org.flasck.flas.parser.FunctionAssembler;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.HandlerBuilder;
import org.flasck.flas.parser.HandlerNameProvider;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.MethodConsumer;
import org.flasck.flas.parser.ObjectNestedNamer;
import org.flasck.flas.parser.SimpleVarNamer;
import org.flasck.flas.parser.TDAAgentElementsParser;
import org.flasck.flas.parser.TDACardElementsParser;
import org.flasck.flas.parser.TDAFunctionParser;
import org.flasck.flas.parser.TDAHandlerParser;
import org.flasck.flas.parser.TDAMethodParser;
import org.flasck.flas.parser.TDAObjectElementsParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAServiceElementsParser;
import org.flasck.flas.parser.TDAStructFieldParser;
import org.flasck.flas.parser.TDATupleDeclarationParser;
import org.flasck.flas.parser.TDAUnionFieldParser;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.parser.TopLevelNamer;
import org.flasck.flas.stories.TDAMultiParser;
import org.flasck.flas.stories.TDAParserConstructor;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.PolyTypeToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.zinutils.exceptions.NotImplementedException;

public class TDAIntroParser
extends BlockLocationTracker
implements TDAParsing {
    private final TopLevelDefinitionConsumer consumer;
    private final TopLevelNamer namer;

    public TDAIntroParser(ErrorReporter errors, TopLevelNamer namer, TopLevelDefinitionConsumer consumer) {
        super(errors, null);
        this.namer = namer;
        this.consumer = consumer;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        if (!toks.hasMoreContent(this.errors)) {
            return null;
        }
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        if (kw == null) {
            return null;
        }
        this.updateLoc(kw.location);
        switch (kw.text) {
            case "agent": 
            case "card": 
            case "service": {
                Locatable hb;
                TypeNameToken tn = TypeNameToken.unqualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid or missing type name");
                    return new IgnoreNestedParser(this.errors);
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra tokens at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                CardName qn = this.namer.cardName(tn.text);
                HandlerNameProvider handlerNamer = text -> new HandlerName(qn, text);
                FunctionNameProvider functionNamer = (loc, text) -> FunctionName.function(loc, qn, text);
                Locatable state = null;
                TDAParserConstructor sh = switch (kw.text) {
                    case "agent" -> {
                        AgentDefinition agent;
                        hb = agent = new AgentDefinition(kw.location, tn.location, qn);
                        state = agent;
                        this.errors.logReduction("agent-declaration-intro", kw.location, tn.location);
                        this.consumer.newAgent(this.errors, agent);
                        yield errors -> new TDAAgentElementsParser(errors, kw.location, new ObjectNestedNamer(qn), agent, this.consumer, agent, this);
                    }
                    case "card" -> {
                        CardDefinition card = new CardDefinition(kw.location, tn.location, qn);
                        hb = card;
                        state = card;
                        this.errors.logReduction("card-declaration-intro", kw.location, tn.location);
                        this.consumer.newCard(this.errors, card);
                        yield errors -> new TDACardElementsParser(errors, kw.location, (TemplateNamer)new ObjectNestedNamer(qn), card, this.consumer, (StateHolder)card, (LocationTracker)this);
                    }
                    case "service" -> {
                        ServiceDefinition svc = new ServiceDefinition(kw.location, tn.location, qn);
                        hb = svc;
                        this.errors.logReduction("service-declaration-intro", kw.location, tn.location);
                        this.consumer.newService(this.errors, svc);
                        yield errors -> new TDAServiceElementsParser(errors, new ObjectNestedNamer(qn), svc, this.consumer, this);
                    }
                    default -> throw new NotImplementedException(kw.text);
                };
                Locatable holder = state;
                FunctionAssembler assembler = new FunctionAssembler(this.errors, this.consumer, (StateHolder)((Object)holder), this);
                return new TDAParsingWithAction(new TDAMultiParser(this.errors, sh, arg_0 -> this.lambda$tryParsing$5((HandlerBuilder)((Object)hb), handlerNamer, (StateHolder)((Object)holder), arg_0), arg_0 -> this.lambda$tryParsing$7(functionNamer, assembler, (StateHolder)((Object)holder), arg_0), arg_0 -> this.lambda$tryParsing$8(functionNamer, (StateHolder)((Object)holder), arg_0)), this.reduction(kw.location, kw.text + "-declaration"));
            }
            case "struct": 
            case "entity": {
                return TDAIntroParser.handleStructLike(this.errors, kw, toks, this.consumer, this.namer, this);
            }
            case "union": {
                TypeNameToken tn = TypeNameToken.unqualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid or missing type name");
                    return new IgnoreNestedParser(this.errors);
                }
                SolidName sn = this.namer.solidName(tn.text);
                SimpleVarNamer svn = new SimpleVarNamer(sn);
                ArrayList<PolyType> polys = new ArrayList<PolyType>();
                while (toks.hasMoreContent(this.errors)) {
                    PolyTypeToken ta = PolyTypeToken.from(this.errors, toks);
                    if (ta == null) {
                        this.errors.message(toks, "invalid type argument");
                        return new IgnoreNestedParser(this.errors);
                    }
                    polys.add(ta.asType(svn));
                }
                this.errors.logReduction("union-defn", kw.location, tn.location);
                UnionTypeDefn ud = new UnionTypeDefn(tn.location, true, this.namer.solidName(tn.text), polys);
                this.consumer.newUnion(this.errors, ud);
                return new TDAUnionFieldParser(this.errors, kw.location, ud);
            }
            case "object": {
                TypeNameToken tn = TypeNameToken.unqualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid or missing type name");
                    return new IgnoreNestedParser(this.errors);
                }
                InputPosition lastLoc = tn.location;
                ObjectName on = this.namer.objectName(tn.text);
                SimpleVarNamer svn = new SimpleVarNamer(on);
                ArrayList<PolyType> polys = new ArrayList<PolyType>();
                while (toks.hasMoreContent(this.errors)) {
                    PolyTypeToken ta = PolyTypeToken.from(this.errors, toks);
                    if (ta == null) {
                        this.errors.message(toks, "syntax error");
                        return new IgnoreNestedParser(this.errors);
                    }
                    polys.add(ta.asType(svn));
                    lastLoc = ta.location;
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "tokens after end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                this.errors.logReduction("object-defn-decl", kw.location, lastLoc);
                ObjectDefn od = new ObjectDefn(kw.location, tn.location, on, true, polys);
                this.consumer.newObject(this.errors, od);
                HandlerNameProvider handlerNamer = text -> new HandlerName(on, text);
                FunctionNameProvider functionNamer = (loc, text) -> FunctionName.function(loc, on, text);
                FunctionAssembler assembler = new FunctionAssembler(this.errors, this.consumer, od, this);
                ObjectNestedNamer onn = new ObjectNestedNamer(on);
                TDAMultiParser ret = new TDAMultiParser(this.errors, errors -> new TDAObjectElementsParser(errors, onn, od, this.consumer, this), errors -> new TDAHandlerParser(errors, od, handlerNamer, this.consumer, od, this), errors -> new TDAFunctionParser(errors, functionNamer, (pos, x, cn) -> onn.functionCase(pos, x, cn), assembler, this.consumer, od, this), errors -> new TDATupleDeclarationParser(errors, functionNamer, this.consumer, od, this));
                return new TDAParsingWithAction(ret, () -> {
                    od.complete(this.errors, this.lastInner());
                    this.reduce(kw.location, "object-declaration");
                });
            }
            case "contract": {
                InputPosition locEnd = kw.location.locAtEnd();
                KeywordToken sh = KeywordToken.from(this.errors, toks);
                ContractDecl.ContractType ct = ContractDecl.ContractType.CONTRACT;
                if (sh != null) {
                    switch (sh.text) {
                        case "service": {
                            ct = ContractDecl.ContractType.SERVICE;
                            locEnd = sh.location;
                            this.errors.logReduction("contract-service", kw.location, locEnd);
                            break;
                        }
                        case "handler": {
                            ct = ContractDecl.ContractType.HANDLER;
                            locEnd = sh.location;
                            this.errors.logReduction("contract-handler", kw.location, locEnd);
                            break;
                        }
                        default: {
                            this.errors.message(sh.location, "invalid contract type");
                            return new IgnoreNestedParser(this.errors);
                        }
                    }
                } else {
                    this.errors.logReduction("contract-card", kw.location, locEnd);
                }
                TypeNameToken tn = TypeNameToken.unqualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid or missing type name");
                    return new IgnoreNestedParser(this.errors);
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "tokens after end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                ContractDecl decl = new ContractDecl(kw.location, tn.location, ct, this.namer.solidName(tn.text));
                this.errors.logReduction("contract-decl-line", kw.location, tn.location);
                this.consumer.newContract(this.errors, decl);
                return new TDAParsingWithAction(new ContractMethodParser(this.errors, kw.location, decl, this.consumer, decl.name(), this), this.reduction(kw.location, "contract-declaration"));
            }
            case "handler": {
                return new TDAHandlerParser(this.errors, null, this.namer, this.consumer, null, this).parseHandler(kw.location, false, toks);
            }
            case "method": {
                MethodConsumer smConsumer = om -> this.consumer.newStandaloneMethod(this.errors, new StandaloneMethod(om));
                return new TDAParsingWithAction(new TDAMethodParser(this.errors, this.namer, smConsumer, this.consumer, null, this, "method-intro", "method-intro", true).parseMethod(kw, this.namer, toks), null);
            }
        }
        return null;
    }

    public static TDAParsing handleStructLike(ErrorReporter errors, KeywordToken kw, Tokenizable toks, TopLevelDefinitionConsumer consumer, TopLevelNamer namer, BlockLocationTracker locTracker) {
        TypeNameToken tn = TypeNameToken.unqualified(errors, toks);
        if (tn == null) {
            errors.message(toks, "invalid or missing type name");
            return new IgnoreNestedParser(errors);
        }
        SolidName sn = namer.solidName(tn.text);
        SimpleVarNamer svn = new SimpleVarNamer(sn);
        ArrayList<PolyType> polys = new ArrayList<PolyType>();
        InputPosition lastLoc = tn.location;
        while (toks.hasMoreContent(errors)) {
            PolyTypeToken ta = PolyTypeToken.from(errors, toks);
            if (ta == null) {
                errors.message(toks, "invalid type argument");
                return new IgnoreNestedParser(errors);
            }
            polys.add(ta.asType(svn));
            lastLoc = ta.location;
        }
        if (toks.hasMoreContent(errors)) {
            errors.message(toks, "tokens after end of line");
            return new IgnoreNestedParser(errors);
        }
        FieldsDefn.FieldsType ty = FieldsDefn.FieldsType.valueOf(kw.text.toUpperCase());
        StructDefn sd = new StructDefn(kw.location, tn.location, ty, sn, true, polys);
        consumer.newStruct(errors, sd);
        errors.logReduction("fields-defn", kw.location, lastLoc);
        return new TDAParsingWithAction(new TDAStructFieldParser(errors, new ConsumeStructFields(errors, consumer, svn, sd), ty, true, locTracker), locTracker.reduction(kw.location, ty == FieldsDefn.FieldsType.STRUCT ? "struct-declaration" : "entity-declaration"));
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }

    public static TDAParserConstructor constructor(final TopLevelNamer namer, final TopLevelDefinitionConsumer consumer) {
        return new TDAParserConstructor(){

            @Override
            public TDAParsing construct(ErrorReporter errors) {
                return new TDAIntroParser(errors, namer, consumer);
            }
        };
    }

    private /* synthetic */ TDAParsing lambda$tryParsing$8(FunctionNameProvider functionNamer, StateHolder holder, ErrorReporter errors) {
        return new TDATupleDeclarationParser(errors, functionNamer, this.consumer, holder, this);
    }

    private /* synthetic */ TDAParsing lambda$tryParsing$7(FunctionNameProvider functionNamer, FunctionAssembler assembler, StateHolder holder, ErrorReporter errors) {
        return new TDAFunctionParser(errors, functionNamer, (pos, base, cn) -> FunctionName.caseName(functionNamer.functionName(pos, base), cn), assembler, this.consumer, holder, this);
    }

    private /* synthetic */ TDAParsing lambda$tryParsing$5(HandlerBuilder hb, HandlerNameProvider handlerNamer, StateHolder holder, ErrorReporter errors) {
        return new TDAHandlerParser(errors, hb, handlerNamer, this.consumer, holder, this);
    }
}

