/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.ImplementationMethodConsumer;
import org.flasck.flas.parser.InnerPackageNamer;
import org.flasck.flas.parser.LastActionScopeParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAMethodGuardParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDAImplementationMethodsParser
extends BlockLocationTracker
implements TDAParsing {
    private final ImplementationMethodConsumer consumer;
    private final FunctionNameProvider namer;
    private final FunctionScopeUnitConsumer topLevel;
    private final StateHolder holder;

    public TDAImplementationMethodsParser(ErrorReporter errors, FunctionNameProvider namer, ImplementationMethodConsumer consumer, FunctionScopeUnitConsumer topLevel, StateHolder holder, LocationTracker parentTracker) {
        super(errors, parentTracker);
        this.namer = namer;
        this.consumer = consumer;
        this.topLevel = topLevel;
        this.holder = holder;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        if (!toks.hasMoreContent(this.errors)) {
            return null;
        }
        ValidIdentifierToken name = VarNameToken.from(this.errors, toks);
        if (name == null) {
            this.errors.message(toks, "invalid method name");
            return new IgnoreNestedParser(this.errors);
        }
        ArrayList<Pattern> args = new ArrayList<Pattern>();
        FunctionName methName = this.namer.functionName(name.location, name.text);
        VarPattern handler = null;
        String withResult = "";
        InputPosition lastLoc = methName.location.locAtEnd();
        boolean sawError = false;
        while (toks.hasMoreContent(this.errors)) {
            ValidIdentifierToken arg = VarNameToken.from(this.errors, toks);
            if (arg == null) {
                ExprToken tok = ExprToken.from(this.errors, toks);
                if (tok != null && "->".equals(tok.text)) {
                    ValidIdentifierToken h = VarNameToken.from(this.errors, toks);
                    if (h == null) {
                        this.errors.message(toks, "missing or invalid handler name");
                        return new IgnoreNestedParser(this.errors);
                    }
                    handler = new VarPattern(h.location, new VarName(h.location, methName, h.text));
                    this.topLevel.argument(this.errors, handler);
                    this.errors.logReduction("implementation-result", tok, h);
                    lastLoc = tok.location;
                    withResult = "-with-result";
                    break;
                }
                this.errors.message(tok.location, "invalid argument name");
                sawError = true;
                break;
            }
            VarPattern vp = new VarPattern(arg.location, new VarName(arg.location, methName, arg.text));
            args.add(vp);
            this.topLevel.argument(this.errors, vp);
            lastLoc = vp.location();
        }
        ObjectMethod meth = new ObjectMethod(name.location, methName, args, handler, this.holder);
        this.errors.logReduction("implementation-method-first-line" + withResult, methName.location, lastLoc);
        super.updateLoc(name.location);
        this.consumer.addImplementationMethod(meth);
        this.topLevel.newObjectMethod(this.errors, meth);
        if (!sawError && toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            sawError = true;
        }
        if (sawError) {
            meth.broke();
            return new IgnoreNestedParser(this.errors);
        }
        InnerPackageNamer innerNamer = new InnerPackageNamer(methName);
        LastActionScopeParser nestedParser = new LastActionScopeParser(this.errors, innerNamer, this.topLevel, "action", this.holder, this);
        return new TDAParsingWithAction(new TDAMethodGuardParser(this.errors, meth, nestedParser, this), () -> {
            if (!meth.messages().isEmpty()) {
                this.reduce(meth.messages().get(0).location(), "method-actions");
            }
            this.reduce(name.location, "implementation-method");
        });
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

