/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.HandlerName;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.HandlerBuilder;
import org.flasck.flas.parser.HandlerNameProvider;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.SimpleVarNamer;
import org.flasck.flas.parser.TDAImplementationMethodsParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAPatternParser;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.stories.TDAParserConstructor;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;

public class TDAHandlerParser
implements TDAParsing,
LocationTracker {
    private final ErrorReporter errors;
    private final HandlerBuilder builder;
    private final HandlerNameProvider namer;
    private final FunctionScopeUnitConsumer topLevel;
    private final StateHolder holder;
    private InputPosition lastInner;
    private LocationTracker locTracker;

    public TDAHandlerParser(ErrorReporter errors, HandlerBuilder builder, HandlerNameProvider provider, FunctionScopeUnitConsumer topLevel, StateHolder holder, LocationTracker tracker) {
        this.errors = errors;
        this.builder = builder;
        this.namer = provider;
        this.topLevel = topLevel;
        this.holder = holder;
        this.locTracker = tracker;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        if (!toks.hasMoreContent(this.errors)) {
            return null;
        }
        KeywordToken kw = KeywordToken.from(this.errors, toks);
        if (kw == null || !kw.text.equals("handler")) {
            kw = null;
            return null;
        }
        return this.parseHandler(kw.location, false, toks);
    }

    @Override
    public void updateLoc(InputPosition location) {
        if (location != null && (this.lastInner == null || location.compareTo(this.lastInner) > 0)) {
            this.lastInner = location;
        }
    }

    @Override
    public InputPosition lastInner() {
        return this.lastInner;
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }

    public TDAParsing parseHandler(InputPosition kw, boolean inCard, Tokenizable line) {
        ErrorMark mark = this.errors.mark();
        if (!line.hasMoreContent(this.errors)) {
            this.errors.message(line, "missing contract reference");
            return new IgnoreNestedParser(this.errors);
        }
        TypeNameToken tn = TypeNameToken.qualified(this.errors, line);
        if (tn == null) {
            this.errors.message(line, "invalid contract reference");
            return new IgnoreNestedParser(this.errors);
        }
        if (!line.hasMoreContent(this.errors)) {
            this.errors.message(line, "missing handler name");
            return new IgnoreNestedParser(this.errors);
        }
        TypeNameToken named = TypeNameToken.unqualified(this.errors, line);
        if (named == null) {
            this.errors.message(line, "invalid handler name");
            return new IgnoreNestedParser(this.errors);
        }
        Locatable upto = named;
        ArrayList<HandlerLambda> lambdas = new ArrayList<HandlerLambda>();
        HandlerName hn = this.namer.handlerName(named.text);
        SimpleVarNamer vn = new SimpleVarNamer(hn);
        while (line.hasMoreContent(this.errors) && !mark.hasMoreNow()) {
            TDAPatternParser pp = new TDAPatternParser(this.errors, vn, patt -> lambdas.add(new HandlerLambda((Pattern)patt, false)), this.topLevel);
            pp.tryParsing(line);
        }
        for (HandlerLambda hl : lambdas) {
            ((TopLevelDefinitionConsumer)this.topLevel).replaceDefinition(hl);
            upto = hl;
        }
        this.errors.logReduction("handler-intro", kw, upto.location());
        this.lastInner = kw;
        HandlerImplements hi = new HandlerImplements(kw, named.location, tn.location, (NamedType)((Object)this.holder), hn, new TypeReference(tn.location, tn.text, new TypeReference[0]), inCard, lambdas);
        if (this.builder != null) {
            this.builder.newHandler(this.errors, hi);
        }
        this.topLevel.newHandler(this.errors, hi);
        return new TDAParsingWithAction(new TDAImplementationMethodsParser(this.errors, (loc, text) -> FunctionName.handlerMethod(loc, hn, text), hi, this.topLevel, hi, this), () -> {
            this.errors.logReduction("handler-definition", kw, this.lastInner);
            if (this.locTracker != null) {
                this.locTracker.updateLoc(kw);
            }
        });
    }

    public static TDAParserConstructor constructor(final HandlerBuilder builder, final HandlerNameProvider namer, final FunctionScopeUnitConsumer topLevel, final StateHolder holder, final LocationTracker locTracker) {
        return new TDAParserConstructor(){

            @Override
            public TDAParsing construct(ErrorReporter errors) {
                return new TDAHandlerParser(errors, builder, namer, topLevel, holder, locTracker);
            }
        };
    }
}

