/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.compiler.ParsingPhase;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FunctionCaseDefn;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.FunctionAssembler;
import org.flasck.flas.parser.FunctionCaseNameProvider;
import org.flasck.flas.parser.FunctionIntroConsumer;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.InnerPackageNamer;
import org.flasck.flas.parser.LastActionScopeParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.SimpleVarNamer;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAFunctionGuardedEquationParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAPatternParser;
import org.flasck.flas.stories.TDAParserConstructor;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDAFunctionParser
extends BlockLocationTracker
implements TDAParsing {
    private final FunctionNameProvider functionNamer;
    private final FunctionCaseNameProvider functionCaseNamer;
    private final FunctionIntroConsumer consumer;
    private final FunctionScopeUnitConsumer topLevel;
    private final StateHolder holder;

    public TDAFunctionParser(ErrorReporter errors, FunctionNameProvider functionNamer, FunctionCaseNameProvider functionCaseNamer, FunctionIntroConsumer consumer, FunctionScopeUnitConsumer topLevel, StateHolder holder, LocationTracker locTracker) {
        super(errors, locTracker);
        this.functionNamer = functionNamer;
        this.functionCaseNamer = functionCaseNamer;
        this.consumer = consumer;
        this.topLevel = topLevel;
        this.holder = holder;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable line) {
        ExprToken t = ExprToken.from(this.errors, line);
        if (t == null || t.type != 1) {
            this.consumer.moveOn();
            return null;
        }
        FunctionName fname = this.functionNamer.functionName(t.location, t.text);
        FunctionName fcase = this.functionCaseNamer.functionCaseName(t.location, t.text, this.consumer.nextCaseNumber(fname));
        ErrorMark currErr = this.errors.mark();
        ArrayList<Pattern> args = new ArrayList<Pattern>();
        TDAPatternParser pp = new TDAPatternParser(this.errors, new SimpleVarNamer(fcase), p -> args.add((Pattern)p), this.topLevel);
        while (pp.tryParsing(line, currErr) != null) {
        }
        if (currErr.hasMoreNow()) {
            return new IgnoreNestedParser(this.errors);
        }
        InnerPackageNamer innerNamer = new InnerPackageNamer(fcase);
        FunctionIntro intro = new FunctionIntro(fcase, args);
        this.consumer.functionIntro(intro);
        if (!line.hasMoreContent(this.errors)) {
            this.consumer.hasGuards(true);
            TDAFunctionGuardedEquationParser inner = new TDAFunctionGuardedEquationParser(this.errors, intro, line.realinfo(), intro, new LastActionScopeParser(this.errors, innerNamer, this.topLevel, "case", this.holder, this), this);
            return new TDAParsingWithAction(inner, () -> {
                this.consumer.done();
                if (!intro.cases().isEmpty()) {
                    if (intro.cases().size() > 1) {
                        if (intro.cases().get((int)(intro.cases().size() - 1)).guard == null) {
                            this.reduce(intro.cases().get((int)0).location, "guarded-equations-with-default");
                        } else {
                            this.reduce(intro.cases().get((int)0).location, "guarded-equations");
                        }
                        this.reduce(t.location, "guarded-function-case-definition");
                    } else if (intro.cases().get((int)0).guard == null) {
                        this.reduce(t.location, "degenerate-guarded-function-case-definition");
                    } else {
                        this.reduce(intro.cases().get((int)0).location, "guarded-equations");
                        this.reduce(t.location, "guarded-function-case-definition");
                    }
                }
            });
        }
        ExprToken tok = ExprToken.from(this.errors, line);
        if (tok == null) {
            return null;
        }
        if (!tok.text.equals("=")) {
            return null;
        }
        if (!line.hasMoreContent(this.errors)) {
            this.errors.message(line, "function definition requires expression");
            return new IgnoreNestedParser(this.errors);
        }
        ArrayList fcds = new ArrayList();
        new TDAExpressionParser(this.errors, e -> {
            FunctionCaseDefn fcd = new FunctionCaseDefn(e.location(), intro, null, (Expr)e);
            fcds.add(fcd);
            intro.functionCase(fcd);
        }).tryParsing(line);
        if (fcds.isEmpty()) {
            return new IgnoreNestedParser(this.errors);
        }
        if (line.hasMoreContent(this.errors)) {
            this.errors.message(line, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.consumer.hasGuards(false);
        super.updateLoc(t.location);
        FunctionAssembler assembler = new FunctionAssembler(this.errors, this.topLevel, this.holder, this);
        return new TDAParsingWithAction(ParsingPhase.functionScopeUnit(this.errors, innerNamer, assembler, this.topLevel, this.holder, this), () -> {
            this.consumer.done();
            this.reduce(t.location, "simple-function-case-definition");
        });
    }

    @Override
    public void choseOther() {
        this.consumer.moveOn();
    }

    @Override
    public void scopeComplete(InputPosition location) {
        this.consumer.moveOn();
    }

    public static TDAParserConstructor constructor(final FunctionNameProvider namer, final FunctionCaseNameProvider caseNamer, final FunctionIntroConsumer consumer, final FunctionScopeUnitConsumer topLevel, final StateHolder holder, final LocationTracker locTracker) {
        return new TDAParserConstructor(){

            @Override
            public TDAParsing construct(ErrorReporter errors) {
                return new TDAFunctionParser(errors, namer, caseNamer, consumer, topLevel, holder, locTracker);
            }
        };
    }
}

