/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FunctionCaseDefn;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.FunctionGuardedEquationConsumer;
import org.flasck.flas.parser.LastOneOnlyNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAExpressionParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDAFunctionGuardedEquationParser
extends BlockLocationTracker
implements TDAParsing {
    private final FunctionIntro intro;
    private final InputPosition afterIntro;
    private final FunctionGuardedEquationConsumer consumer;
    private final List<FunctionCaseDefn> cases = new ArrayList<FunctionCaseDefn>();
    private InputPosition haveDefault;
    private LastOneOnlyNestedParser nestedParser;
    private boolean reportedDefault;
    private InputPosition lastInner;

    public TDAFunctionGuardedEquationParser(ErrorReporter errors, FunctionIntro intro, InputPosition afterIntro, FunctionGuardedEquationConsumer consumer, LastOneOnlyNestedParser nestedParser, LocationTracker locTracker) {
        super(errors, locTracker);
        this.intro = intro;
        this.afterIntro = afterIntro;
        this.consumer = consumer;
        this.nestedParser = nestedParser;
        nestedParser.bindLocationTracker(this);
    }

    @Override
    public TDAParsing tryParsing(Tokenizable line) {
        ErrorMark mark = this.errors.mark();
        this.nestedParser.anotherParent();
        InputPosition start = line.realinfo();
        ExprToken tok = ExprToken.from(this.errors, line);
        if (tok == null) {
            this.errors.message(line, "syntax error in function case definition");
            return null;
        }
        if (!tok.text.equals("=") && !tok.text.equals("|")) {
            this.errors.message(tok.location, "syntax error in function case definition");
            return null;
        }
        if (!line.hasMoreContent(this.errors)) {
            this.errors.message(line, "function definition requires expression");
            return null;
        }
        ArrayList optionalGuard = new ArrayList();
        if (mark.hasMoreNow()) {
            return null;
        }
        if (this.haveDefault != null) {
            if (!this.reportedDefault) {
                this.errors.message(start, "default case has already been specified");
                this.reportedDefault = true;
            }
            return null;
        }
        if (tok.text.equals("|")) {
            new TDAExpressionParser(this.errors, e -> optionalGuard.add(e)).tryParsing(line);
            if (mark.hasMoreNow()) {
                return null;
            }
            ExprToken equals = ExprToken.from(this.errors, line);
            if (equals == null || !equals.text.equals("=")) {
                this.errors.message(line, "syntax error");
                return null;
            }
            if (!line.hasMoreContent(this.errors)) {
                this.errors.message(line, "function definition requires expression");
                return null;
            }
        } else {
            this.haveDefault = start;
        }
        ArrayList fcds = new ArrayList();
        new TDAExpressionParser(this.errors, e -> {
            Expr guard;
            Expr expr = guard = optionalGuard.isEmpty() ? null : (Expr)optionalGuard.get(0);
            if (guard != null) {
                this.errors.logReduction("function-case-with-guard", tok.location(), e.location());
            } else {
                this.errors.logReduction("function-case-default", tok.location, e.location());
            }
            this.tellParent(tok.location);
            FunctionCaseDefn fcd = new FunctionCaseDefn(tok.location, this.intro, guard, (Expr)e);
            fcds.add(fcd);
            this.consumer.functionCase(fcd);
            this.cases.add(fcd);
        }).tryParsing(line);
        this.lastInner = tok.location;
        return new TDAParsingWithAction(this.nestedParser, () -> {});
    }

    @Override
    public void updateLoc(InputPosition location) {
        if (location != null && (this.lastInner == null || location.compareTo(this.lastInner) > 0)) {
            this.lastInner = location;
        }
    }

    @Override
    public void scopeComplete(InputPosition location) {
        if (this.cases.isEmpty() && !this.errors.hasErrors()) {
            this.errors.message(this.afterIntro, "no function cases specified");
            this.consumer.breakIt();
        }
    }
}

