/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.NumericLiteral;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AnonymousVar;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.CheckTypeExpr;
import org.flasck.flas.parsedForm.DotOperator;
import org.flasck.flas.parsedForm.TypeExpr;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.ExprTermConsumer;
import org.flasck.flas.parser.ParenTermConsumer;
import org.flasck.flas.parser.Punctuator;
import org.flasck.flas.parser.StackDumper;
import org.zinutils.exceptions.NotImplementedException;

public class TDAExprReducer
implements ExprTermConsumer {
    private final ErrorReporter errors;
    private final ErrorMark mark;
    private final ExprTermConsumer builder;
    private final List<Expr> terms = new ArrayList<Expr>();
    private final List<OpPrec> ops = new ArrayList<OpPrec>();
    private DotOperator haveDot;
    private boolean haveErrors;
    private boolean reduceToOne;

    public TDAExprReducer(ErrorReporter errors, ExprTermConsumer builder, boolean reduceToOne) {
        this.errors = errors;
        this.mark = errors.mark();
        this.builder = builder;
        this.reduceToOne = reduceToOne;
    }

    @Override
    public boolean isTop() {
        return false;
    }

    @Override
    public void term(Expr term) {
        if (this.haveErrors) {
            return;
        }
        if (this.haveDot != null) {
            if (!(term instanceof UnresolvedVar) && !(term instanceof TypeReference)) {
                this.errors.message(term.location(), "field access requires a field name");
                this.haveErrors = true;
                return;
            }
            Expr strobj = this.terms.remove(this.terms.size() - 1);
            if (term instanceof TypeReference) {
                this.errors.logReduction("type-member", strobj, term);
            } else {
                this.errors.logReduction("value-member", strobj, term);
            }
            this.terms.add(new MemberExpr(strobj.location().copySetEnd(term.location().pastEnd()), strobj, term));
            this.haveDot = null;
            return;
        }
        if (term instanceof Punctuator) {
            if (((Punctuator)term).is(":")) {
                term = new UnresolvedOperator(term.location(), ":");
            } else {
                this.errors.message(term.location(), "invalid tokens after expression");
                this.haveErrors = true;
                return;
            }
        }
        if (term instanceof DotOperator) {
            if (this.terms.isEmpty()) {
                this.errors.message(term.location(), "field access requires a struct or object");
                this.haveErrors = true;
                return;
            }
            this.haveDot = (DotOperator)term;
            return;
        }
        if (term instanceof UnresolvedOperator) {
            UnresolvedOperator op = (UnresolvedOperator)term;
            this.ops.add(new OpPrec(this.terms.size(), this.precedence(term.location(), op.op)));
        }
        this.terms.add(term);
    }

    public void seenComma(Punctuator comma) {
        this.builder.term(this.reduce(0, this.terms.size()));
        if (this.builder instanceof ParenTermConsumer.ParenCloseRewriter) {
            ((ParenTermConsumer.ParenCloseRewriter)this.builder).commaAt(comma);
        }
        this.terms.clear();
        this.ops.clear();
    }

    public void seenColon(ParenTermConsumer.ParenCloseRewriter closer) {
        Expr t = this.terms.get(0);
        if (t instanceof UnresolvedVar) {
            UnresolvedVar uv = (UnresolvedVar)t;
            closer.defineVar(new StringLiteral(uv.location(), uv.var));
        } else if (t instanceof StringLiteral) {
            closer.defineVar((StringLiteral)t);
        }
        this.terms.clear();
    }

    @Override
    public void done() {
        if (!this.haveErrors && this.haveDot != null) {
            this.errors.message(this.haveDot.location(), "field access requires an explicit field name");
            this.haveErrors = true;
        }
        if (!this.haveErrors && !this.terms.isEmpty()) {
            if (this.reduceToOne) {
                Expr r = this.reduce(0, this.terms.size());
                if (r != null) {
                    this.builder.term(r);
                }
            } else {
                for (Expr t : this.terms) {
                    this.builder.term(t);
                }
            }
        }
        this.builder.done();
    }

    private Expr reduce(int from, int to) {
        OpPrec op = null;
        for (OpPrec p : this.ops) {
            if (p.pos < from || p.pos >= to || op != null && p.prec >= op.prec) continue;
            op = p;
        }
        if (op != null) {
            return this.handleOperators(from, to, op.pos, op.prec);
        }
        return this.fncall(from, to);
    }

    private Expr handleOperators(int from, int to, int oppos, int prec) {
        Expr oe = this.terms.get(oppos);
        if (oppos == from) {
            UnresolvedOperator op = (UnresolvedOperator)oe;
            Expr rhs = this.reduce(oppos + 1, to);
            this.errors.logReduction("expr-unop", op, rhs);
            return new ApplyExpr(oe.location().copySetEnd(this.terms.get(to - 1).location().pastEnd()), (Object)oe, rhs);
        }
        if (prec == 10) {
            throw new NotImplementedException();
        }
        Expr rhs = this.reduce(oppos + 1, to);
        Expr lhs = this.reduce(from, oppos);
        this.errors.logReduction("expr-binop", lhs, rhs);
        return new ApplyExpr(this.terms.get(from).location().copySetEnd(this.terms.get(this.terms.size() - 1).location().pastEnd()), (Object)oe, lhs, rhs);
    }

    private Expr fncall(int from, int to) {
        Expr t0 = this.terms.get(from);
        if (this.isCastExpr(t0)) {
            return this.resolveCastExpr(t0, from, to);
        }
        if (this.isTypeExpr(t0)) {
            return this.resolveTypeExpr(t0, from, to);
        }
        if (this.isCheckTypeExpr(t0)) {
            return this.resolveCheckTypeExpr(t0, from, to);
        }
        if (from + 1 == to && !this.isConstructor(t0)) {
            return this.reduceSingletonToExpression(t0);
        }
        this.errors.logReduction("function-call", t0, this.terms.get(to - 1));
        return new ApplyExpr(t0.location().copySetEnd(this.terms.get(to - 1).location().pastEnd()), (Object)t0, this.args(from + 1, to).toArray());
    }

    private Expr reduceSingletonToExpression(Expr t0) {
        if (t0 instanceof UnresolvedVar || t0 instanceof AnonymousVar) {
            this.errors.logReduction("function-call", t0, t0);
        } else if (t0 instanceof NumericLiteral) {
            this.errors.logReduction("literal", t0, t0);
        } else if (t0 instanceof StringLiteral) {
            this.errors.logReduction("literal", t0, t0);
        }
        return t0;
    }

    private boolean isConstructor(Expr t0) {
        return t0 instanceof TypeReference;
    }

    private boolean isCastExpr(Expr t0) {
        return t0 instanceof UnresolvedVar && ((UnresolvedVar)t0).isCast();
    }

    private boolean isTypeExpr(Expr t0) {
        return t0 instanceof UnresolvedVar && ((UnresolvedVar)t0).isType();
    }

    private boolean isCheckTypeExpr(Expr t0) {
        return t0 instanceof UnresolvedVar && ((UnresolvedVar)t0).isCheckType();
    }

    private Expr resolveCastExpr(Expr t0, int from, int to) {
        TypeReference tr;
        if (this.mark.hasMoreNow()) {
            return null;
        }
        if (to != from + 3) {
            this.errors.message(t0.location(), "cast must have exactly two arguments");
            return null;
        }
        Expr type = this.terms.get(from + 1);
        Expr val = this.reduceSingletonToExpression(this.terms.get(from + 2));
        if (type instanceof TypeReference) {
            tr = (TypeReference)type;
        } else if (type instanceof MemberExpr) {
            MemberExpr me = (MemberExpr)type;
            tr = this.resolveMemberExprToTypeReference(me);
            if (tr == null) {
                return null;
            }
        } else {
            this.errors.message(type.location(), "syntax error in cast");
            return null;
        }
        this.errors.logReduction("cast-expr", t0, this.terms.get(to - 1));
        return new CastExpr(t0.location().copySetEnd(type.location().pastEnd()), type.location(), val.location(), tr, val);
    }

    private TypeReference resolveMemberExprToTypeReference(MemberExpr me) {
        String prefix;
        if (me.from instanceof MemberExpr) {
            TypeReference inner = this.resolveMemberExprToTypeReference((MemberExpr)me.from);
            if (inner == null) {
                return null;
            }
            prefix = inner.name();
        } else if (me.from instanceof UnresolvedVar) {
            prefix = ((UnresolvedVar)me.from).var;
        } else {
            return null;
        }
        return new TypeReference(me.location(), prefix + "." + me.fld, new TypeReference[0]);
    }

    private Expr resolveTypeExpr(Expr t0, int from, int to) {
        if (to != from + 2) {
            this.errors.message(t0.location(), "type must have exactly one argument");
            return null;
        }
        Expr expr = this.terms.get(from + 1);
        if (expr instanceof TypeReference) {
            this.errors.logReduction("type-expr-type", t0, expr);
        } else {
            this.reduceSingletonToExpression(expr);
            this.errors.logReduction("type-expr-expr", t0, expr);
        }
        return new TypeExpr(t0.location().copySetEnd(expr.location().pastEnd()), expr.location(), expr);
    }

    private Expr resolveCheckTypeExpr(Expr t0, int from, int to) {
        if (to != from + 3) {
            this.errors.message(t0.location(), "istype must have exactly two arguments");
            return null;
        }
        Expr type = this.terms.get(from + 1);
        Expr expr = this.terms.get(from + 2);
        this.errors.logReduction("check-type-expr", t0, expr);
        return new CheckTypeExpr(t0.location().copySetEnd(type.location().pastEnd()), type.location(), type, expr);
    }

    private List<Expr> args(int from, int to) {
        ArrayList<Expr> ret = new ArrayList<Expr>();
        for (int i = from; i < to; ++i) {
            ret.add(this.terms.get(i));
        }
        return ret;
    }

    private int precedence(InputPosition pos, String op) {
        boolean isUnary = this.terms.isEmpty() || !this.ops.isEmpty() && this.ops.get((int)(this.ops.size() - 1)).pos == this.terms.size() - 1;
        switch (op) {
            case "!": {
                return 7;
            }
            case "-": {
                return isUnary ? 7 : 5;
            }
            case "*": 
            case "/": 
            case "%": {
                return 6;
            }
            case "+": 
            case "++": {
                return 5;
            }
            case ":": {
                return 4;
            }
            case "==": 
            case "<>": 
            case "<": 
            case "<=": 
            case "!=": 
            case ">": 
            case ">=": {
                return 3;
            }
            case "&&": 
            case "||": {
                return 2;
            }
            case "->": {
                return 1;
            }
        }
        this.errors.message(pos, "there is no precedence for operator " + op);
        return 0;
    }

    @Override
    public void showStack(StackDumper d) {
        d.dump(this.terms);
    }

    public static class OpPrec {
        int pos;
        int prec;

        public OpPrec(int pos, int prec) {
            this.pos = pos;
            this.prec = prec;
        }
    }
}

