/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.function.Consumer;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.NumericLiteral;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AnonymousVar;
import org.flasck.flas.parsedForm.DotOperator;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parser.ExprReducerErrors;
import org.flasck.flas.parser.ExprTermConsumer;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.Punctuator;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDATypeReferenceParser;
import org.flasck.flas.parser.VarNamer;
import org.flasck.flas.parser.ut.IntroduceNamer;
import org.flasck.flas.parser.ut.IntroductionConsumer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class TDAExprParser
implements TDAParsing {
    private final ErrorReporter origErrors;
    private final IntroduceNamer namer;
    private final ExprTermConsumer builder;
    private final ExprReducerErrors errors;
    private final IntroductionConsumer consumer;

    public TDAExprParser(ErrorReporter origErrors, ExprReducerErrors errors, IntroduceNamer namer, ExprTermConsumer builder, IntroductionConsumer consumer) {
        this.origErrors = origErrors;
        this.errors = errors;
        this.namer = namer;
        this.builder = builder;
        this.consumer = consumer;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable line) {
        boolean wantFullTypeReduction = false;
        block7: while (true) {
            int mark = line.at();
            ExprToken tok = ExprToken.from(this.errors, line);
            if (tok == null) {
                this.builder.done();
                return new IgnoreNestedParser(this.origErrors);
            }
            switch (tok.type) {
                case 2: {
                    this.builder.term(new NumericLiteral(tok.location, tok.text, -1));
                    continue block7;
                }
                case 5: {
                    this.builder.term(new StringLiteral(tok.location, tok.text));
                    continue block7;
                }
                case 1: {
                    Expr term;
                    if (Character.isAlphabetic(tok.text.charAt(0))) {
                        if (Character.isLowerCase(tok.text.charAt(0))) {
                            term = new UnresolvedVar(tok.location, tok.text);
                            if ("cast".equals(tok.text)) {
                                wantFullTypeReduction = true;
                            }
                        } else {
                            line.reset(mark);
                            ArrayList ltr = new ArrayList();
                            Consumer<TypeReference> captureTR = tr -> ltr.add(tr);
                            new TDATypeReferenceParser(this.errors, (VarNamer)((Object)this.namer), wantFullTypeReduction, captureTR, (FunctionScopeUnitConsumer)((Object)this.consumer)).tryParsing(line);
                            if (ltr.isEmpty()) {
                                this.errors.cancelReduction();
                                return new IgnoreNestedParser(this.origErrors);
                            }
                            term = (Expr)ltr.get(0);
                            wantFullTypeReduction = false;
                        }
                    } else if (tok.text.equals("_")) {
                        term = new AnonymousVar(tok.location);
                    } else if (this.consumer != null && tok.text.startsWith("_")) {
                        IntroduceVar iv = new IntroduceVar(tok.location, this.namer, tok.text.substring(1));
                        this.consumer.newIntroduction(this.errors, iv);
                        term = iv;
                    } else {
                        this.errors.message(tok.location, "syntax error");
                        this.errors.cancelReduction();
                        return new IgnoreNestedParser(this.origErrors);
                    }
                    this.builder.term(term);
                    continue block7;
                }
                case 4: {
                    if ("=".equals(tok.text) || "=>".equals(tok.text) || "<-".equals(tok.text)) {
                        line.reset(mark);
                        this.errors.cancel(tok);
                        this.builder.done();
                        return new IgnoreNestedParser(this.origErrors);
                    }
                    this.builder.term(new UnresolvedOperator(tok.location, tok.text));
                    continue block7;
                }
                case 3: {
                    if (tok.text.equals(".")) {
                        this.builder.term(new DotOperator(tok.location));
                        wantFullTypeReduction = false;
                        continue block7;
                    }
                    if (tok.text.equals(")") && this.builder.isTop()) {
                        line.reset(mark);
                        this.errors.cancel(tok);
                        this.builder.done();
                        if (!this.errors.hasErrors()) {
                            this.errors.doneReducing();
                        }
                        return new IgnoreNestedParser(this.origErrors);
                    }
                    this.builder.term(new Punctuator(tok.location, tok.text));
                    continue block7;
                }
            }
            break;
        }
        throw new RuntimeException("Not found");
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

