/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.HandlerName;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parser.CardElementsConsumer;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.MethodConsumer;
import org.flasck.flas.parser.TDAAgentElementsParser;
import org.flasck.flas.parser.TDAMethodParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDATemplateBindingParser;
import org.flasck.flas.parser.TDATypeReferenceParser;
import org.flasck.flas.parser.TemplateBindingConsumer;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.resolver.NestingChain;
import org.flasck.flas.resolver.TemplateNestingChain;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.TemplateNameToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;

public class TDACardElementsParser
extends TDAAgentElementsParser {
    public TDACardElementsParser(ErrorReporter errors, InputPosition kwloc, TemplateNamer namer, CardElementsConsumer consumer, TopLevelDefinitionConsumer topLevel, StateHolder holder, LocationTracker tracker) {
        super(errors, kwloc, namer, consumer, topLevel, holder, tracker);
    }

    @Override
    protected TDAParsing strategy(KeywordToken kw, Tokenizable toks) {
        CardElementsConsumer consumer = (CardElementsConsumer)this.consumer;
        switch (kw.text) {
            case "template": {
                TemplateNameToken tn = TemplateNameToken.from(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "template must have a name");
                    return new IgnoreNestedParser(this.errors);
                }
                InputPosition lastLoc = tn.location;
                int pos = consumer.templatePosn();
                if (pos == 0 && toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "main template cannot declare chain");
                    return new IgnoreNestedParser(this.errors);
                }
                ErrorMark em2 = this.errors.mark();
                NestingChain chain = null;
                if (pos > 0) {
                    chain = TDACardElementsParser.parseChain(this.errors, this.namer, toks);
                    if (em2.hasMoreNow()) {
                        return new IgnoreNestedParser(this.errors);
                    }
                    if (chain.location() != null) {
                        lastLoc = chain.location();
                    }
                }
                if (chain != null && !chain.isEmpty()) {
                    this.errors.logReduction("template-introduction-with-chain", kw.location, lastLoc);
                } else {
                    this.errors.logReduction("template-introduction", kw.location, lastLoc);
                }
                this.updateLoc(kw.location);
                Template template = new Template(kw.location, tn.location, consumer.templateName(tn.location, tn.text), pos, chain);
                consumer.addTemplate(template);
                this.topLevel.newTemplate(this.errors, template);
                TemplateBindingCaptureLoc c = new TemplateBindingCaptureLoc(this, template);
                return new TDAParsingWithAction(new TDATemplateBindingParser(this.errors, template, this.namer, c, this), this.reduction(kw.location, "named-template-definition"));
            }
            case "event": {
                this.updateLoc(kw.location);
                this.tellParent(kw.location);
                FunctionNameProvider namer = (loc, text) -> FunctionName.eventMethod(loc, consumer.cardName(), text);
                MethodConsumer evConsumer = em -> {
                    if (em.args().size() != 1) {
                        this.errors.message(toks, "event handlers must have exactly one (typed) argument");
                        return;
                    }
                    Pattern ev = em.args().get(0);
                    if (ev instanceof VarPattern) {
                        this.errors.message(ev.location(), "event arguments must be typed");
                        return;
                    }
                    ev.isDefinedBy(em);
                    em.eventFor((CardDefinition)consumer);
                    consumer.addEventHandler(em);
                    this.topLevel.newObjectMethod(this.errors, em);
                };
                TDAMethodParser np = new TDAMethodParser(this.errors, this.namer, evConsumer, this.topLevel, this.holder, this, null, "event-from-method", false);
                return new TDAParsingWithAction(np.parseMethod(kw, namer, toks), np.reduction(kw.location, "event-handler"));
            }
        }
        return null;
    }

    public static NestingChain parseChain(ErrorReporter errors, TemplateNamer namer, Tokenizable toks) {
        TemplateNestingChain chain = new TemplateNestingChain(namer);
        if (toks.hasMoreContent(errors)) {
            ExprToken send = ExprToken.from(errors, toks);
            if (!"<-".equals(send.text)) {
                errors.message(send.location, "expected <-");
                return null;
            }
            InputPosition chainN = null;
            while (toks.hasMoreContent(errors)) {
                chainN = TDACardElementsParser.readChainElement(errors, namer, toks, chain);
                if (chainN != null) continue;
                return null;
            }
            errors.logReduction("define-template-chain", send.location, chainN);
        }
        return chain;
    }

    private static InputPosition readChainElement(ErrorReporter errors, TemplateNamer namer, Tokenizable toks, NestingChain chain) {
        ExprToken tok = ExprToken.from(errors, toks);
        if (tok == null || !"(".equals(tok.text)) {
            errors.message(toks, "( expected");
            return null;
        }
        InputPosition orb = tok.location;
        ArrayList ref = new ArrayList();
        if (new TDATypeReferenceParser(errors, namer, true, x -> ref.add(x), null).tryParsing(toks) == null) {
            return null;
        }
        TypeReference tr = (TypeReference)ref.get(0);
        ValidIdentifierToken var = ValidIdentifierToken.from(errors, toks);
        if (var == null) {
            errors.message(toks, "var name expected");
            return null;
        }
        tok = ExprToken.from(errors, toks);
        if (!")".equals(tok.text)) {
            errors.message(toks, ") expected");
            return null;
        }
        errors.logReduction("template-chain-var", orb, tok.location);
        chain.declare(tr, namer.nameVar(var.location, var.text));
        return orb;
    }

    @Override
    public FunctionName functionName(InputPosition location, String base) {
        return FunctionName.function(location, this.consumer.cardName(), base);
    }

    @Override
    public HandlerName handlerName(String baseName) {
        return new HandlerName(this.consumer.cardName(), baseName);
    }

    private static class TemplateBindingCaptureLoc
    implements TemplateBindingConsumer {
        private final LocationTracker tracker;
        private final Template template;

        private TemplateBindingCaptureLoc(LocationTracker tracker, Template template) {
            this.tracker = tracker;
            this.template = template;
        }

        @Override
        public void addStyling(TemplateStylingOption style) {
            this.tracker.updateLoc(style.location());
            this.template.addStyling(style);
        }

        @Override
        public void addBinding(TemplateBinding binding) {
            this.tracker.updateLoc(binding.location());
            this.template.addBinding(binding);
        }
    }
}

