/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.blocker.TDAParsingWithAction;
import org.flasck.flas.commonBase.names.CSName;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.HandlerName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FieldsDefn;
import org.flasck.flas.parsedForm.ImplementsContract;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.StandaloneMethod;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.AgentElementsConsumer;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.ConsumeStructFields;
import org.flasck.flas.parser.FunctionNameProvider;
import org.flasck.flas.parser.HandlerNameProvider;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.MethodConsumer;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.TDAImplementationMethodsParser;
import org.flasck.flas.parser.TDAMethodParser;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAStructFieldParser;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.parser.TopLevelDefinitionConsumer;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.TypeNameToken;
import org.flasck.flas.tokenizers.ValidIdentifierToken;
import org.flasck.flas.tokenizers.VarNameToken;

public class TDAAgentElementsParser
extends BlockLocationTracker
implements TDAParsing,
FunctionNameProvider,
HandlerNameProvider {
    protected final InputPosition kwloc;
    protected final TemplateNamer namer;
    protected final AgentElementsConsumer consumer;
    protected final TopLevelDefinitionConsumer topLevel;
    protected final StateHolder holder;
    private boolean seenState;
    private KeywordToken kw;

    public TDAAgentElementsParser(ErrorReporter errors, InputPosition kwloc, TemplateNamer namer, AgentElementsConsumer consumer, TopLevelDefinitionConsumer topLevel, StateHolder holder, LocationTracker tracker) {
        super(errors, tracker);
        this.kwloc = kwloc;
        this.namer = namer;
        this.consumer = consumer;
        this.topLevel = topLevel;
        this.holder = holder;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        this.kw = KeywordToken.from(this.errors, toks);
        if (this.kw == null) {
            return null;
        }
        switch (this.kw.text) {
            case "state": {
                if (this.seenState) {
                    this.errors.message(this.kw.location, "multiple state declarations");
                    return new IgnoreNestedParser(this.errors);
                }
                StateDefinition state = new StateDefinition(this.kw.location, toks.realinfo(), this.consumer.name());
                this.consumer.defineState(state);
                this.seenState = true;
                this.errors.logReduction("state-line", this.kw.location, this.kw.location.locAtEnd());
                this.updateLoc(this.kw.location);
                return new TDAParsingWithAction(new TDAStructFieldParser(this.errors, new ConsumeStructFields(this.errors, this.topLevel, this.namer, state), FieldsDefn.FieldsType.STATE, false, this), this.reduction(this.kw.location, "state-declaration"));
            }
            case "provides": {
                TypeNameToken tn = TypeNameToken.qualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid contract reference");
                    return new IgnoreNestedParser(this.errors);
                }
                InputPosition varloc = null;
                String varname = null;
                if (toks.hasMoreContent(this.errors)) {
                    ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
                    if (var == null) {
                        this.errors.message(toks, "invalid service var name");
                        return new IgnoreNestedParser(this.errors);
                    }
                    varloc = var.location;
                    varname = var.text;
                    this.updateLoc(varloc);
                    this.errors.logReduction("provides-contract-name-with-var", this.kw.location, varloc);
                } else {
                    this.updateLoc(tn.location);
                    this.errors.logReduction("provides-contract-name", this.kw.location, tn.location);
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra tokens at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                TypeReference ctr = this.namer.contract(tn.location, tn.text);
                CSName csn = this.namer.csn(tn.location, "S");
                Provides contractService = new Provides(this.kw.location, tn.location, this.consumer, ctr, csn, varloc, varname);
                this.consumer.addProvidedService(contractService);
                if (varname != null) {
                    this.topLevel.newProvidesServiceWithName(this.errors, contractService);
                }
                return new TDAParsingWithAction(new TDAImplementationMethodsParser(this.errors, (loc, text) -> FunctionName.contractMethod(loc, csn, text), contractService, this.topLevel, this.holder, this), this.reduction(this.kw.location, "provides-contract"));
            }
            case "requires": {
                TypeNameToken tn = TypeNameToken.qualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid contract reference");
                    return new IgnoreNestedParser(this.errors);
                }
                InputPosition lastLoc = tn.location;
                InputPosition varloc = null;
                String varname = null;
                if (toks.hasMoreContent(this.errors)) {
                    ValidIdentifierToken var = VarNameToken.from(this.errors, toks);
                    if (var == null) {
                        this.errors.message(toks, "invalid service var name");
                        return new IgnoreNestedParser(this.errors);
                    }
                    lastLoc = varloc = var.location;
                    varname = var.text;
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra tokens at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                TypeReference ctr = this.namer.contract(tn.location, tn.text);
                CSName cin = this.namer.csn(tn.location, "R");
                RequiresContract rc = new RequiresContract(this.kw.location, tn.location, this.consumer, ctr, cin, varloc, varname);
                this.consumer.addRequiredContract(rc);
                this.topLevel.newRequiredContract(this.errors, rc);
                this.errors.logReduction("requires-contract", this.kw.location, lastLoc);
                this.tellParent(tn.location);
                return new NoNestingParser(this.errors);
            }
            case "implements": {
                TypeNameToken tn = TypeNameToken.qualified(this.errors, toks);
                if (tn == null) {
                    this.errors.message(toks, "invalid contract reference");
                    return new IgnoreNestedParser(this.errors);
                }
                if (toks.hasMoreContent(this.errors)) {
                    this.errors.message(toks, "extra tokens at end of line");
                    return new IgnoreNestedParser(this.errors);
                }
                TypeReference ctr = this.namer.contract(tn.location, tn.text);
                CSName cin = this.namer.csn(tn.location, "C");
                ImplementsContract ci = new ImplementsContract(this.kw.location, tn.location, (NamedType)this.consumer, ctr, cin);
                this.errors.logReduction("agent-implements-contract-decl", this.kw.location, tn.location);
                this.updateLoc(this.kw.location);
                this.consumer.addContractImplementation(ci);
                this.topLevel.newContractImpl(this.errors, ci);
                return new TDAParsingWithAction(new TDAImplementationMethodsParser(this.errors, (loc, text) -> FunctionName.contractMethod(loc, cin, text), ci, this.topLevel, ci, this), this.reduction(this.kw.location, "implements-contract"));
            }
            case "method": {
                FunctionNameProvider namer = (loc, text) -> FunctionName.standaloneMethod(loc, this.consumer.cardName(), text);
                MethodConsumer smConsumer = om -> this.topLevel.newStandaloneMethod(this.errors, new StandaloneMethod(om));
                TDAMethodParser mp = new TDAMethodParser(this.errors, this.namer, smConsumer, this.topLevel, this.holder, this, null, "method-intro", true);
                return new TDAParsingWithAction(mp.parseMethod(this.kw, namer, toks), null);
            }
        }
        return this.strategy(this.kw, toks);
    }

    protected TDAParsing strategy(KeywordToken kw, Tokenizable toks) {
        return null;
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }

    @Override
    public FunctionName functionName(InputPosition location, String base) {
        return FunctionName.function(location, this.consumer.cardName(), base);
    }

    @Override
    public HandlerName handlerName(String baseName) {
        return new HandlerName(this.consumer.cardName(), baseName);
    }
}

