/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.TDAParseTemplateElements;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TemplateNamer;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;

public class RequireEventsParser
extends BlockLocationTracker
implements TDAParsing {
    private final InputPosition loc;
    private final Template source;
    private final TemplateNamer namer;
    private final TemplateStylingOption tso;
    private boolean seenHandler;

    public RequireEventsParser(ErrorReporter errors, InputPosition location, Template source, TemplateNamer namer, TemplateStylingOption tso, LocationTracker locTracker) {
        super(errors, locTracker);
        this.loc = location;
        this.source = source;
        this.namer = namer;
        this.tso = tso;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        ExprToken tok = ExprToken.from(this.errors, toks);
        if (tok == null) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        this.tellParent(tok.location);
        if ("|".equals(tok.text)) {
            this.seenHandler = true;
            return TDAParseTemplateElements.parseStyling(this.errors, tok.location, this.source, this.namer, toks, nested -> this.tso.conditionalStylings.add(nested), this);
        }
        if ("=>".equals(tok.text)) {
            this.seenHandler = true;
            return TDAParseTemplateElements.parseEventHandling(tok, this.errors, this.source, toks, ev -> this.tso.events.add(ev), this);
        }
        this.errors.message(toks, "event handler expected");
        return new IgnoreNestedParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
        if (!this.seenHandler) {
            this.errors.message(this.loc, "must provide styles and/or nested content");
        }
    }
}

