/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parser.ExprTermConsumer;
import org.flasck.flas.parser.ParenTermConsumer;

public class Punctuator
implements Expr {
    public final InputPosition location;
    public final String punc;

    public Punctuator(InputPosition location, String punc) {
        this.location = location;
        this.punc = punc;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    public ExprTermConsumer openParenParser(ErrorReporter errors, ExprTermConsumer builder) {
        if (!this.punc.equals("(")) {
            throw new RuntimeException("Can only call this with open paren");
        }
        return new ParenTermConsumer(this.location, errors, builder, this);
    }

    public ExprTermConsumer openSquareParser(ErrorReporter errors, ExprTermConsumer builder) {
        if (!this.punc.equals("[")) {
            throw new RuntimeException("Can only call this with open square");
        }
        return new ParenTermConsumer(this.location, errors, builder, this);
    }

    public ExprTermConsumer openCurlyParser(ErrorReporter errors, ExprTermConsumer builder) {
        if (!this.punc.equals("{")) {
            throw new RuntimeException("Can only call this with open curly");
        }
        return new ParenTermConsumer(this.location, errors, builder, this);
    }

    public boolean is(String punc) {
        return this.punc.equals(punc);
    }

    public void checkCloserFor(ErrorReporter errors, Punctuator open) {
        if (this.is(")") && !open.is("(") || this.is("]") && !open.is("[") || this.is("}") && !open.is("{")) {
            errors.message(this.location, "mismatched parentheses: " + this.punc + " does not close " + open.punc);
        }
    }

    public String toString() {
        return this.punc;
    }
}

