/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.ParenExpr;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.UnresolvedOperator;
import org.flasck.flas.parser.ExprTermConsumer;
import org.flasck.flas.parser.Punctuator;
import org.flasck.flas.parser.StackDumper;
import org.flasck.flas.parser.TDAExprReducer;
import org.zinutils.exceptions.NotImplementedException;

public class ParenTermConsumer
implements ExprTermConsumer {
    private final ErrorReporter errors;
    private final ExprTermConsumer builder;
    private final Punctuator open;
    private final ParenCloseRewriter closer;
    private final TDAExprReducer curr;
    private boolean expectingColon;
    private Punctuator comma;

    public ParenTermConsumer(InputPosition from, ErrorReporter errors, ExprTermConsumer builder, Punctuator open) {
        this.errors = errors;
        this.builder = builder;
        this.open = open;
        if (open.is("(")) {
            this.closer = new ParenCloseRewriter(open, "()");
        } else if (open.is("[")) {
            this.closer = new ParenCloseRewriter(open, "[]");
        } else if (open.is("{")) {
            this.closer = new ParenCloseRewriter(open, "{}");
            this.expectingColon = true;
        } else {
            throw new RuntimeException("invalid open paren");
        }
        this.curr = new TDAExprReducer(errors, this.closer, true);
    }

    @Override
    public boolean isTop() {
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void term(Expr term) {
        if (term instanceof Punctuator) {
            Punctuator punc = (Punctuator)term;
            if (punc.is(")") || punc.is("]") || punc.is("}")) {
                punc.checkCloserFor(this.errors, this.open);
                this.closer.endAt(term);
                this.curr.done();
                return;
            } else if (punc.is(",")) {
                this.comma = punc;
                this.curr.seenComma(this.comma);
                if (!this.closer.isObjectLiteral()) return;
                this.expectingColon = true;
                return;
            } else if (punc.is(":")) {
                if (this.closer.isObjectLiteral() && this.expectingColon && punc.is(":")) {
                    this.curr.seenColon(this.closer);
                    this.expectingColon = false;
                    return;
                } else {
                    this.curr.term(new UnresolvedOperator(punc.location, ":"));
                }
                return;
            } else {
                if (!punc.is("(")) throw new RuntimeException("Unexpected punc: " + punc);
                this.curr.term(term);
            }
            return;
        } else {
            this.curr.term(term);
        }
    }

    @Override
    public void done() {
        throw new RuntimeException("I don't think we should get here");
    }

    @Override
    public void showStack(StackDumper d) {
        this.curr.showStack(d);
    }

    public class ParenCloseRewriter
    implements ExprTermConsumer {
        private final Locatable from;
        private final String op;
        private Expr endToken;
        private int end;
        private final List<Expr> terms = new ArrayList<Expr>();
        private StringLiteral currentVar;
        private Punctuator comma;

        public ParenCloseRewriter(Punctuator from, String op) {
            this.from = from;
            this.op = op;
        }

        @Override
        public boolean isTop() {
            return false;
        }

        public void endAt(Expr term) {
            this.endToken = term;
            this.end = term.location().pastEnd();
        }

        public void defineVar(StringLiteral sl) {
            if (!this.op.equals("{}")) {
                throw new RuntimeException("Can't use colon here");
            }
            this.currentVar = sl;
        }

        @Override
        public void term(Expr term) {
            if (this.op.equals("{}")) {
                if (this.currentVar == null) {
                    throw new RuntimeException("need field and colon");
                }
                ParenTermConsumer.this.errors.logReduction("object-member", this.currentVar, term);
                term = new ApplyExpr(this.currentVar.location().copySetEnd(this.end), (Object)new UnresolvedOperator(this.from.location(), ":"), this.currentVar, term);
            }
            if (this.comma != null) {
                if (this.op.equals("()")) {
                    ParenTermConsumer.this.errors.logReduction("comma-expression", this.comma, term);
                } else if (this.op.equals("[]")) {
                    ParenTermConsumer.this.errors.logReduction("comma-expression", this.comma, term);
                } else if (this.op.equals("{}")) {
                    ParenTermConsumer.this.errors.logReduction("comma-object-member", this.comma, term);
                }
                this.comma = null;
            }
            this.terms.add(term);
        }

        @Override
        public void done() {
            if (this.terms.size() == 0) {
                if (this.op.equals("()")) {
                    ParenTermConsumer.this.errors.message(this.from.location(), "empty tuples are not permitted");
                    return;
                }
                if (this.op.equals("[]")) {
                    ParenTermConsumer.this.errors.logReduction("empty-list-literal", this.from, this.endToken);
                } else {
                    ParenTermConsumer.this.errors.logReduction("empty-object-literal", this.from, this.endToken);
                }
                ParenTermConsumer.this.builder.term(new ApplyExpr(this.from.location().copySetEnd(this.end), (Object)new UnresolvedOperator(this.from.location(), this.op), new Object[0]));
                return;
            }
            Expr ae = this.terms.get(0);
            if (this.terms.size() == 1 && this.op.equals("()")) {
                ParenTermConsumer.this.errors.logReduction("paren-expression", this.from, this.endToken);
                ParenTermConsumer.this.builder.term(new ParenExpr(this.from.location().copySetEnd(this.end), ae));
            } else {
                if (this.op.equals("[]")) {
                    ParenTermConsumer.this.errors.logReduction("non-empty-list-literal", this.from, this.endToken);
                } else if (this.op.equals("{}")) {
                    ParenTermConsumer.this.errors.logReduction("non-empty-object-literal", this.from, this.endToken);
                } else {
                    ParenTermConsumer.this.errors.logReduction("tuple-expression", this.from, this.endToken);
                }
                ParenTermConsumer.this.builder.term(new ApplyExpr(this.from.location().copySetEnd(this.end), (Object)new UnresolvedOperator(ae.location(), this.op), this.terms.toArray()));
            }
        }

        @Override
        public void showStack(StackDumper d) {
            throw new NotImplementedException();
        }

        public boolean isObjectLiteral() {
            return this.op.equals("{}");
        }

        public void commaAt(Punctuator comma) {
            this.comma = comma;
        }
    }
}

