/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parser.BlockLocationTracker;
import org.flasck.flas.parser.FunctionIntroConsumer;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.LocationTracker;

public class FunctionAssembler
extends BlockLocationTracker
implements FunctionIntroConsumer {
    private final FunctionScopeUnitConsumer consumer;
    private final StateHolder holder;
    private FunctionDefinition fn;
    private FunctionIntro curr;
    private boolean broken;
    private boolean hasGuards;

    public FunctionAssembler(ErrorReporter errors, FunctionScopeUnitConsumer consumer, StateHolder holder, LocationTracker tracker) {
        super(errors, tracker);
        this.consumer = consumer;
        this.holder = holder;
    }

    @Override
    public int nextCaseNumber(FunctionName fname) {
        if (this.fn != null && this.fn.name().uniqueName().equals(fname.uniqueName())) {
            return this.fn.intros().size() + 1;
        }
        return 1;
    }

    @Override
    public void functionIntro(FunctionIntro next) {
        FunctionName fname = (FunctionName)next.name().inContext;
        if (this.curr != null) {
            this.reduceCurr();
        }
        if (this.fn != null && !fname.equals(this.fn.name())) {
            this.reduceFunction();
        }
        if (this.fn == null) {
            this.fn = new FunctionDefinition(fname, next.args.size(), this.holder);
        } else if (this.fn.argCount() != next.args.size()) {
            this.errors.message(next.location, "inconsistent number of formal parameters");
            this.broken = true;
            this.consumer.functionDefn(this.errors, this.fn);
            return;
        }
        this.fn.intro(next);
        this.curr = next;
    }

    @Override
    public void hasGuards(boolean hasGuards) {
        this.hasGuards = hasGuards;
    }

    @Override
    public void done() {
        if (this.curr != null) {
            this.reduceCurr();
            this.curr = null;
        }
    }

    @Override
    public void moveOn() {
        if (this.curr != null) {
            this.reduceCurr();
            this.curr = null;
        }
        if (this.fn != null) {
            this.reduceFunction();
            this.fn = null;
        }
    }

    private void reduceCurr() {
        if (this.curr.cases().size() == 1) {
            if (!this.hasGuards) {
                this.errors.logReduction("simple-function-case-definition-intro", this.curr.location(), this.curr.cases().get((int)0).expr.location());
            } else {
                InputPosition to = this.curr.location;
                if (!this.curr.args.isEmpty()) {
                    to = this.curr.args.get(this.curr.args.size() - 1).location();
                }
                if (this.curr.cases().get((int)0).guard == null) {
                    this.errors.logReduction("degenerate-guarded-function-case-definition-intro", this.curr.location(), to);
                } else {
                    this.errors.logReduction("guarded-function-case-definition-intro", this.curr.location(), to);
                }
            }
        } else {
            InputPosition to = this.curr.location;
            if (!this.curr.args.isEmpty()) {
                to = this.curr.args.get(this.curr.args.size() - 1).location();
            }
            if (!this.curr.cases().isEmpty()) {
                this.errors.logReduction("guarded-function-case-definition-intro", this.curr.location(), to);
            }
        }
    }

    private void reduceFunction() {
        if (!this.broken && this.fn != null) {
            this.consumer.functionDefn(this.errors, this.fn);
        }
        this.fn = null;
        this.curr = null;
        this.broken = false;
    }

    public String toString() {
        if (this.curr == null && this.fn == null) {
            return "Assembler[]";
        }
        if (this.fn != null) {
            return "Assembler[" + this.fn.name() + "]";
        }
        return "Assembler[" + this.curr + "]";
    }
}

