/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.FLASError;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.tokenizers.CommentToken;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class ExprReducerErrors
implements ErrorReporter {
    private final ErrorReporter errors;
    private final Map<InputPosition, Composite> linear = new TreeMap<InputPosition, Composite>();
    private final boolean reduceToOne;

    public ExprReducerErrors(ErrorReporter errors, boolean reduceToOne) {
        this.errors = errors;
        this.reduceToOne = reduceToOne;
    }

    @Override
    public void track(File f) {
        this.errors.track(f);
    }

    @Override
    public <T extends LoggableToken> T logParsingToken(T token) {
        if (token instanceof CommentToken) {
            this.errors.logParsingToken(token);
            return token;
        }
        this.linear.put(token.location(), new Composite(token));
        return token;
    }

    public void cancel(ExprToken tok) {
        this.linear.remove(tok.location);
    }

    @Override
    public void logReduction(String ruleId, Locatable first, Locatable last) {
        Iterator<Map.Entry<InputPosition, Composite>> it = this.linear.entrySet().iterator();
        ArrayList<Composite> collect = new ArrayList<Composite>();
        boolean collecting = false;
        while (it.hasNext()) {
            Map.Entry<InputPosition, Composite> e = it.next();
            InputPosition loc = e.getKey();
            Composite curr = e.getValue();
            if (loc.equals(first.location())) {
                collecting = true;
            } else if (!collecting && loc.compareTo(first.location()) > 0) {
                throw new CantHappenException("write a message");
            }
            if (!collecting) continue;
            collect.add(curr);
            it.remove();
            if (loc.equals(last.location())) {
                collecting = false;
                break;
            }
            if (curr.last != null && last.location().equals(curr.last.location())) {
                collecting = false;
                break;
            }
            if (loc.compareTo(last.location()) <= 0) continue;
            throw new CantHappenException("the token on the stack is past where we should have found the last token");
        }
        if (collecting) {
            throw new CantHappenException("should be false");
        }
        if (collect.isEmpty()) {
            throw new CantHappenException("nothing matched");
        }
        this.linear.put(first.location(), new Composite(ruleId, first, last, collect));
    }

    @Override
    public void logReduction(String ruleId, InputPosition from, InputPosition to) {
        try {
            throw new NotImplementedException("don't use this form in expression reduction");
        }
        catch (NotImplementedException ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public void cancelReduction() {
    }

    public void doneReducing() {
        if (this.reduceToOne && this.linear.size() > 1) {
            for (Map.Entry<InputPosition, Composite> e : this.linear.entrySet()) {
                System.out.println(e.getKey() + " ====> " + e.getValue());
            }
            throw new CantHappenException("Not fully reduced: " + this.linear.size());
        }
        for (Map.Entry<InputPosition, Composite> e : this.linear.entrySet()) {
            this.dumpTreeInPostfixOrder(e.getValue());
        }
    }

    private void dumpTreeInPostfixOrder(Composite comp) {
        if (comp.tok != null) {
            this.errors.logParsingToken(comp.tok);
        } else {
            for (Composite e : comp.collect) {
                this.dumpTreeInPostfixOrder(e);
            }
            this.errors.logReduction(comp.ruleId, comp.first, comp.last);
        }
    }

    @Override
    public ErrorReporter message(InputPosition pos, String msg) {
        return this.errors.message(pos, msg);
    }

    @Override
    public ErrorReporter message(InputPosition pos, Collection<InputPosition> locs, String msg) {
        return this.errors.message(pos, locs, msg);
    }

    @Override
    public ErrorReporter message(Tokenizable line, String msg) {
        return this.errors.message(line, msg);
    }

    @Override
    public ErrorReporter message(FLASError e) {
        return this.errors.message(e);
    }

    @Override
    public ErrorReporter reportException(Throwable ex) {
        return this.errors.reportException(ex);
    }

    @Override
    public boolean hasErrors() {
        return this.errors.hasErrors();
    }

    @Override
    public ErrorMark mark() {
        return this.errors.mark();
    }

    @Override
    public void showFromMark(ErrorMark mark, Writer pw, int ind) {
        this.errors.showFromMark(mark, pw, ind);
    }

    @Override
    public void beginPhase1(URI uri) {
        this.errors.beginPhase1(uri);
    }

    @Override
    public void doneProcessing(List<URI> broken) {
        this.errors.doneProcessing(broken);
    }

    @Override
    public List<URI> getAllBrokenURIs() {
        return this.errors.getAllBrokenURIs();
    }

    @Override
    public void logMessage(String s) {
        this.errors.logMessage(s);
    }

    @Override
    public void beginPhase2(URI uri) {
        this.errors.beginPhase2(uri);
    }

    public class Composite {
        private final LoggableToken tok;
        private final String ruleId;
        private final Locatable first;
        private final Locatable last;
        private final List<Composite> collect;

        public <T extends LoggableToken> Composite(T token) {
            this.tok = token;
            this.ruleId = null;
            this.first = null;
            this.last = null;
            this.collect = null;
        }

        public Composite(String ruleId, Locatable first, Locatable last, List<Composite> collect) {
            this.tok = null;
            this.ruleId = ruleId;
            this.first = first;
            this.last = last;
            this.collect = collect;
        }

        public String toString() {
            if (this.tok != null) {
                return "T[" + this.tok + "]";
            }
            if (this.ruleId != null) {
                return "R[" + this.ruleId + ":" + this.collect + "]";
            }
            return super.toString();
        }
    }
}

