/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import java.util.ArrayList;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parser.ContractConsumer;
import org.flasck.flas.parser.ContractMethodConsumer;
import org.flasck.flas.parser.FunctionScopeUnitConsumer;
import org.flasck.flas.parser.IgnoreNestedParser;
import org.flasck.flas.parser.LocationTracker;
import org.flasck.flas.parser.NoNestingParser;
import org.flasck.flas.parser.SimpleVarNamer;
import org.flasck.flas.parser.TDAParsing;
import org.flasck.flas.parser.TDAPatternParser;
import org.flasck.flas.tokenizers.ExprToken;
import org.flasck.flas.tokenizers.KeywordToken;
import org.flasck.flas.tokenizers.Tokenizable;
import org.flasck.flas.tokenizers.ValidIdentifierToken;

public class ContractMethodParser
implements TDAParsing {
    private final ErrorReporter errors;
    private final ContractMethodConsumer builder;
    private final FunctionScopeUnitConsumer topLevel;
    private final SolidName cname;
    private final LocationTracker locTracker;

    public ContractMethodParser(ErrorReporter errors, InputPosition kwloc, ContractMethodConsumer builder, FunctionScopeUnitConsumer topLevel, SolidName cname, LocationTracker locTracker) {
        this.errors = errors;
        this.builder = builder;
        this.topLevel = topLevel;
        this.cname = cname;
        this.locTracker = locTracker;
    }

    @Override
    public TDAParsing tryParsing(Tokenizable toks) {
        ValidIdentifierToken name;
        ErrorMark emark = this.errors.mark();
        boolean required = true;
        InputPosition optLoc = null;
        InputPosition firstLoc = null;
        int mark = toks.at();
        String withOptional = "";
        KeywordToken ud = KeywordToken.from(this.errors, toks);
        if (ud != null) {
            if (ud.text.equals("optional")) {
                required = false;
                firstLoc = optLoc = ud.location;
                withOptional = "-with-optional";
            } else {
                toks.reset(mark);
            }
        }
        InputPosition pos = toks.realinfo();
        if (firstLoc == null) {
            firstLoc = pos;
        }
        if ((name = ValidIdentifierToken.from(this.errors, toks)) == null) {
            if (toks.hasMoreContent(this.errors)) {
                this.errors.message(toks, "invalid method name");
            } else {
                this.errors.message(toks, "missing method name");
            }
            return new NoNestingParser(this.errors);
        }
        if (Character.isUpperCase(name.text.charAt(0))) {
            this.errors.message(pos, "invalid method name");
            return new NoNestingParser(this.errors);
        }
        InputPosition lastLoc = name.location;
        FunctionName fnName = FunctionName.contractDecl(name.location, this.cname, name.text);
        ArrayList args = new ArrayList();
        TDAPatternParser pp = new TDAPatternParser(this.errors, new SimpleVarNamer(fnName), x -> args.add(x), this.topLevel);
        while (pp.tryParsing(toks) != null) {
        }
        ArrayList<TypedPattern> targs = new ArrayList<TypedPattern>();
        for (Pattern p : args) {
            if (!(p instanceof TypedPattern)) {
                this.errors.message(p.location(), "contract patterns must be typed");
                continue;
            }
            targs.add((TypedPattern)p);
            lastLoc = p.location();
        }
        if (emark.hasMoreNow()) {
            return new IgnoreNestedParser(this.errors);
        }
        String withHandler = "";
        TypedPattern handler = null;
        if (toks.hasMoreContent(this.errors)) {
            ExprToken tok = ExprToken.from(this.errors, toks);
            if (!"->".equals(tok.text)) {
                this.errors.message(tok.location, "syntax error");
                return new IgnoreNestedParser(this.errors);
            }
            ArrayList hdlrs = new ArrayList();
            TDAPatternParser hp = new TDAPatternParser(this.errors, new SimpleVarNamer(fnName), x -> hdlrs.add(x), this.topLevel);
            hp.tryParsing(toks);
            if (hdlrs.size() != 1) {
                this.errors.message(toks, "no handler specified");
                return new IgnoreNestedParser(this.errors);
            }
            Pattern p = (Pattern)hdlrs.get(0);
            if (!(p instanceof TypedPattern)) {
                this.errors.message(p.location(), "contract handler must be a typed pattern");
                return new IgnoreNestedParser(this.errors);
            }
            handler = (TypedPattern)p;
            lastLoc = p.location();
            withHandler = "-with-handler";
            this.errors.logReduction("handled-by", tok, handler);
        }
        if (toks.hasMoreContent(this.errors)) {
            this.errors.message(toks, "syntax error");
            return new IgnoreNestedParser(this.errors);
        }
        if (this.locTracker != null) {
            this.locTracker.updateLoc(firstLoc);
        }
        ContractMethodDecl ret = new ContractMethodDecl(optLoc, name.location, name.location, required, fnName, targs, handler);
        this.builder.addMethod(ret);
        this.errors.logReduction("contract-method-decl" + withOptional + withHandler, firstLoc, lastLoc);
        ((ContractConsumer)((Object)this.topLevel)).newContractMethod(this.errors, ret);
        return new NoNestingParser(this.errors);
    }

    @Override
    public void scopeComplete(InputPosition location) {
    }
}

