/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parser;

import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parser.LocationTracker;

public class BlockLocationTracker
implements LocationTracker {
    private final LocationTracker parent;
    protected final ErrorReporter errors;
    private InputPosition lastInner;

    public BlockLocationTracker(ErrorReporter errors, LocationTracker parent) {
        this.errors = errors;
        this.parent = parent;
    }

    @Override
    public void updateLoc(InputPosition location) {
        if (location != null && (this.lastInner == null || location.compareTo(this.lastInner) > 0)) {
            this.lastInner = location;
        }
    }

    protected LocationTracker parentTracker() {
        return this.parent;
    }

    @Override
    public InputPosition lastInner() {
        return this.lastInner;
    }

    public void reduce(InputPosition from, String rule) {
        this.updateLoc(from);
        this.errors.logReduction(rule, from, this.lastInner);
        if (this.parent != null) {
            this.parent.updateLoc(from);
        }
    }

    public Runnable reduction(final InputPosition from, final String rule) {
        return new Runnable(){

            @Override
            public void run() {
                BlockLocationTracker.this.reduce(from, rule);
            }
        };
    }

    protected void tellParent(InputPosition location) {
        if (this.parent != null) {
            this.parent.updateLoc(location);
        }
    }
}

