/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm.assembly;

import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.names.AssemblyName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.assembly.SubRouting;
import org.flasck.flas.parser.assembly.MainRoutingGroupConsumer;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.NotImplementedException;

public class ApplicationRouting
extends SubRouting
implements MainRoutingGroupConsumer,
NamedType {
    private final InputPosition location;
    private final NameOfThing packageName;
    private final NameOfThing name;
    private final Map<String, CardBinding> cards = new HashMap<String, CardBinding>();
    public boolean sawMainCard;

    public ApplicationRouting(ErrorReporter errors, InputPosition location, NameOfThing packageName, AssemblyName name) {
        super(errors, null, null, null);
        this.location = location;
        this.packageName = packageName;
        this.name = name;
    }

    public NameOfThing packageName() {
        return this.packageName;
    }

    @Override
    public NameOfThing name() {
        return this.name;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public void provideMainCard(TypeReference main) {
        if (this.sawMainCard) {
            this.errors.message(main.location(), "duplicate assignment to main card");
            return;
        }
        this.sawMainCard = true;
    }

    @Override
    public CardBinding nameCard(UnresolvedVar var, TypeReference cardType) {
        String s = var.var;
        CardBinding ret = new CardBinding(var, cardType);
        if (this.cards.containsKey(s)) {
            this.errors.message(var.location(), "duplicate card binding of " + s);
            return ret;
        }
        this.cards.put(s, ret);
        return ret;
    }

    public CardBinding getCard(String var) {
        return this.cards.get(var);
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println("routing " + this.name);
    }

    @Override
    public String signature() {
        throw new NotImplementedException();
    }

    @Override
    public int argCount() {
        throw new NotImplementedException();
    }

    @Override
    public Type get(int pos) {
        throw new NotImplementedException();
    }

    @Override
    public boolean incorporates(InputPosition pos, Type other) {
        throw new NotImplementedException();
    }

    public class CardBinding
    implements RepositoryEntry {
        public final UnresolvedVar var;
        public final TypeReference cardType;
        private final VarName myname;

        public CardBinding(UnresolvedVar var, TypeReference cardType) {
            this.var = var;
            this.cardType = cardType;
            this.myname = new VarName(var.location, ApplicationRouting.this.name, var.var);
        }

        @Override
        public NameOfThing name() {
            return this.myname;
        }

        @Override
        public InputPosition location() {
            return this.var.location;
        }

        @Override
        public void dumpTo(PrintWriter pw) {
            pw.println("card binding " + this.myname.uniqueName());
        }

        public StateHolder type() {
            return (StateHolder)((Object)this.cardType.namedDefn());
        }
    }
}

