/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.VarName;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.WithTypeSignature;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tc3.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VarPattern
implements Pattern,
RepositoryEntry,
WithTypeSignature {
    private static final Logger logger = LoggerFactory.getLogger((String)"TypeChecker");
    public static Comparator<VarPattern> comparator = new Comparator<VarPattern>(){

        @Override
        public int compare(VarPattern o1, VarPattern o2) {
            return o1.name().compareTo(o2.name());
        }
    };
    private InputPosition varLoc;
    public final String var;
    private final VarName myName;
    private Type type;
    private LogicHolder definedBy;
    private final List<VarPattern> transitiveBinds = new ArrayList<VarPattern>();

    public VarPattern(InputPosition location, VarName name) {
        this.varLoc = location;
        this.var = name.var;
        this.myName = name;
    }

    public String toString() {
        return this.myName.uniqueName();
    }

    @Override
    public InputPosition location() {
        return this.varLoc;
    }

    @Override
    public Pattern locatedAt(InputPosition location) {
        this.varLoc = location;
        return this;
    }

    @Override
    public LogicHolder definedBy() {
        return this.definedBy;
    }

    @Override
    public void isDefinedBy(LogicHolder definedBy) {
        this.definedBy = definedBy;
    }

    @Override
    public VarName name() {
        return this.myName;
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println("VarPattern[" + this.toString() + "]");
    }

    public void bindType(Type ty) {
        logger.info("binding type of varpattern[" + this + "] to " + ty);
        this.type = ty;
        for (VarPattern vp : this.transitiveBinds) {
            vp.bindType(ty);
        }
    }

    public boolean hasBoundType() {
        return this.type != null;
    }

    @Override
    public Type type() {
        return this.type;
    }

    @Override
    public String signature() {
        return this.type.signature();
    }

    @Override
    public int argCount() {
        return this.type.argCount();
    }

    public Type get(int pos) {
        return this.type.get(pos);
    }

    public boolean incorporates(Type other) {
        return this.type.incorporates(this.varLoc, other);
    }

    public void transitiveBind(VarPattern vp) {
        if (this.type != null) {
            vp.bindType(this.type);
        } else {
            this.transitiveBinds.add(vp);
        }
    }
}

