/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.PolyHolder;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parser.UnionFieldConsumer;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.UnionFinder;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.UnifiableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.collections.SetMap;
import org.zinutils.exceptions.NotImplementedException;

public class UnionTypeDefn
implements Locatable,
UnionFieldConsumer,
RepositoryEntry,
PolyHolder {
    private static final Logger logger = LoggerFactory.getLogger((String)"TCUnification");
    public final transient boolean generate;
    private final InputPosition location;
    private final SolidName name;
    public final List<TypeReference> cases = new ArrayList<TypeReference>();
    private List<PolyType> polyvars;

    public UnionTypeDefn(InputPosition location, boolean generate, SolidName defining, PolyType ... polyvars) {
        this(location, generate, defining, Arrays.asList(polyvars));
    }

    public UnionTypeDefn(InputPosition location, boolean generate, SolidName defining, List<PolyType> polyvars) {
        this.generate = generate;
        this.location = location;
        this.name = defining;
        this.polyvars = polyvars;
    }

    @Override
    public SolidName name() {
        return this.name;
    }

    @Override
    public boolean hasPolys() {
        return !this.polyvars.isEmpty();
    }

    @Override
    public UnionTypeDefn addCase(TypeReference tr) {
        this.cases.add(tr);
        return this;
    }

    public String toString() {
        return this.name.uniqueName() + this.polyvars;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public List<PolyType> polys() {
        return this.polyvars;
    }

    public Type matches(ErrorReporter errors, InputPosition pos, UnionFinder finder, Set<Type> members, boolean needAll) {
        HashSet<String> all = new HashSet<String>();
        HashSet<String> remaining = new HashSet<String>();
        for (TypeReference typeReference : this.cases) {
            all.add(typeReference.namedDefn().name().uniqueName());
            remaining.add(typeReference.namedDefn().name().uniqueName());
        }
        logger.debug("considering if " + this + " is a match for " + members + " with needAll = " + needAll);
        logger.debug("have cases " + this.cases);
        SetMap polys = new SetMap();
        for (Type type : members) {
            NamedType sd;
            if (type == this) {
                remaining.clear();
                continue;
            }
            if (type instanceof StructDefn || type instanceof UnionTypeDefn) {
                sd = (NamedType)type;
            } else if (type instanceof PolyInstance) {
                TypeReference mine;
                PolyInstance pi = (PolyInstance)type;
                sd = pi.struct();
                if (sd == this) {
                    remaining.clear();
                    ArrayList<TypeReference> trs = new ArrayList<TypeReference>();
                    for (PolyType pt : this.polyvars) {
                        trs.add(new TypeReference(pt.location(), pt.shortName(), new TypeReference[0]).bind(pt));
                    }
                    mine = new TypeReference(this.location, this.name.baseName(), trs);
                    mine.bind(this);
                } else {
                    mine = this.findCase(sd.name().uniqueName());
                    if (mine == null) {
                        logger.debug("not " + this.signature() + " because there is no case to handle " + sd.name().uniqueName());
                        return null;
                    }
                }
                List<Type> pip = pi.polys();
                if (!mine.hasPolys() || pip.size() != mine.polys().size()) {
                    throw new NotImplementedException("I can't see how this isn't an error that should have been caught somewhere else");
                }
                for (int i = 0; i < pip.size(); ++i) {
                    polys.add((Object)mine.polys().get(i).name(), (Object)pip.get(i));
                }
            } else {
                logger.debug("rejecting because something");
                return null;
            }
            if (sd != this && !all.contains(sd.name().uniqueName())) {
                logger.debug("rejecting because something");
                return null;
            }
            remaining.remove(sd.name().uniqueName());
        }
        if (needAll && !remaining.isEmpty()) {
            logger.debug("rejecting because all are needed and we are missing " + remaining);
            return null;
        }
        if (!polys.isEmpty()) {
            ArrayList<Type> arrayList = new ArrayList<Type>();
            for (PolyType pt : this.polyvars) {
                if (polys.contains((Object)pt.shortName())) {
                    Type ut;
                    Set tr = polys.get((Object)pt.shortName());
                    if (tr.size() == 1) {
                        ut = (Type)tr.iterator().next();
                    } else {
                        ut = finder.findUnionWith(errors, pos, tr, true);
                        if (ut == null) {
                            return null;
                        }
                    }
                    arrayList.add(ut);
                    continue;
                }
                arrayList.add(LoadBuiltins.any);
            }
            PolyInstance polyInstance = new PolyInstance(this.location(), this, arrayList);
            logger.debug("returning " + polyInstance);
            return polyInstance;
        }
        logger.debug("returning " + this);
        return this;
    }

    public TypeReference findCase(String ctor) {
        for (TypeReference c : this.cases) {
            if (!c.name().equals(ctor)) continue;
            return c;
        }
        return null;
    }

    public boolean hasCase(StructDefn sd) {
        for (TypeReference c : this.cases) {
            if (!c.namedDefn().equals(sd)) continue;
            return true;
        }
        return false;
    }

    @Override
    public String signature() {
        return this.name.uniqueName();
    }

    @Override
    public int argCount() {
        return 0;
    }

    @Override
    public Type get(int pos) {
        throw new NotImplementedException();
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println("Union[" + this.toString() + "]");
    }

    @Override
    public boolean incorporates(InputPosition pos, Type other) {
        if (this == other) {
            return true;
        }
        if (other instanceof UnifiableType) {
            ((UnifiableType)other).incorporatedBy(pos, this);
            return true;
        }
        if (other instanceof PolyInstance) {
            Type struct = this.removePoly(other);
            block0: for (TypeReference ty : this.cases) {
                Type cs;
                if (!(ty.namedDefn() instanceof PolyInstance) || (cs = this.removePoly(ty.namedDefn())) != struct) continue;
                PolyInstance opi = (PolyInstance)other;
                PolyInstance cpi = (PolyInstance)ty.namedDefn();
                for (int i = 0; i < cpi.polys().size(); ++i) {
                    Type ci = cpi.polys().get(i);
                    if (!(ci instanceof PolyType) && ci != opi.polys().get(i)) continue block0;
                }
                return true;
            }
        } else {
            for (TypeReference ty : this.cases) {
                if (this.removePoly(ty.namedDefn()) != other) continue;
                return true;
            }
        }
        return false;
    }

    public Type removePoly(Type other) {
        while (other instanceof PolyInstance) {
            other = ((PolyInstance)other).struct();
        }
        return other;
    }
}

