/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.util.Arrays;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.UtilException;

public class TypeReference
implements Expr {
    private InputPosition location;
    private String name;
    private List<TypeReference> polys;
    private NamedType definition;
    private Apply applyDefn;
    private boolean dynamic;

    public TypeReference(InputPosition location, String name, TypeReference ... polys) {
        this(location, name, Arrays.asList(polys));
    }

    public TypeReference(InputPosition location, String name, List<TypeReference> polys) {
        if (location == null) {
            throw new UtilException("Null location in typereference");
        }
        this.location = location;
        this.name = name;
        this.polys = polys;
    }

    public String name() {
        return this.name;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    public boolean hasPolys() {
        return this.polys != null && !this.polys.isEmpty();
    }

    public List<TypeReference> polys() {
        return this.polys;
    }

    public String toString() {
        return this.name + (this.polys != null && !this.polys.isEmpty() ? this.polys : "");
    }

    public TypeReference bind(Type ty) {
        if (this.dynamic) {
            throw new CantHappenException("you cannot bind a dynamic type directly");
        }
        if (ty instanceof NamedType) {
            this.definition = (NamedType)ty;
        } else if (ty instanceof Apply) {
            this.applyDefn = (Apply)ty;
        }
        return this;
    }

    public Type defn() {
        if (this.dynamic) {
            throw new CantHappenException("you need to access dynamic type references with resolveType");
        }
        if (this.definition != null) {
            return this.definition;
        }
        if (this.applyDefn != null) {
            return this.applyDefn;
        }
        throw new CantHappenException("no type definition");
    }

    public NamedType namedDefn() {
        if (this.dynamic) {
            throw new CantHappenException("you need to access dynamic type references with resolveType");
        }
        if (this.definition == null && this.applyDefn != null) {
            throw new CantHappenException("you need to call applyDefn for this");
        }
        return this.definition;
    }

    public Apply applyDefn() {
        if (this.dynamic) {
            throw new CantHappenException("you need to access dynamic type references with resolveType");
        }
        if (this.definition != null && this.applyDefn == null) {
            throw new CantHappenException("you need to call defn for this");
        }
        return this.applyDefn;
    }

    public boolean isDynamic() {
        return this.dynamic;
    }

    public TypeReference bindDynamically() {
        this.dynamic = true;
        return this;
    }

    public Type resolveType(RepositoryReader repository) {
        if (!this.dynamic) {
            throw new CantHappenException("no, this should be bound statically");
        }
        if (!this.polys.isEmpty()) {
            throw new HaventConsideredThisException("resolving type with polys");
        }
        return (Type)repository.get(this.name);
    }
}

