/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.names.TemplateName;
import org.flasck.flas.parsedForm.TemplateBinding;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parser.TemplateBindingConsumer;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.resolver.NestingChain;
import org.flasck.flas.tc3.Type;
import org.ziniki.splitter.CardData;

public class Template
implements Locatable,
RepositoryEntry,
TemplateBindingConsumer {
    public final InputPosition kw;
    private final InputPosition loc;
    private final List<TemplateBinding> bindings = new ArrayList<TemplateBinding>();
    private final List<TemplateStylingOption> stylings = new ArrayList<TemplateStylingOption>();
    private final TemplateName name;
    private final int posn;
    private final NestingChain chain;
    private CardData webInfo;

    public Template(InputPosition kw, InputPosition loc, TemplateName name, int posn, NestingChain chain) {
        this.kw = kw;
        this.loc = loc;
        this.name = name;
        this.posn = posn;
        this.chain = chain;
    }

    @Override
    public void clean() {
        RepositoryEntry.super.clean();
        if (this.chain != null) {
            this.chain.clean();
        }
        this.webInfo = null;
    }

    public InputPosition kwlocation() {
        return this.kw;
    }

    @Override
    public InputPosition location() {
        return this.loc;
    }

    @Override
    public TemplateName name() {
        return this.name;
    }

    public void bindWebInfo(CardData webInfo) {
        this.webInfo = webInfo;
    }

    public CardData webinfo() {
        return this.webInfo;
    }

    public int position() {
        return this.posn;
    }

    @Override
    public void addBinding(TemplateBinding binding) {
        this.bindings.add(binding);
    }

    public Iterable<TemplateBinding> bindings() {
        return this.bindings;
    }

    @Override
    public void addStyling(TemplateStylingOption x) {
        this.stylings.add(x);
    }

    public Iterable<TemplateStylingOption> stylings() {
        return this.stylings;
    }

    public void canUse(Type ty) {
        if (this.chain != null) {
            this.chain.addInferred(this.loc, ty);
        }
    }

    public NestingChain nestingChain() {
        return this.chain;
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println(this);
    }

    public String toString() {
        return "Template[" + this.name.uniqueName() + "]";
    }
}

