/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.EventHolder;
import org.flasck.flas.parsedForm.HandlerHolder;
import org.flasck.flas.parsedForm.Implements;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parsedForm.WithTypeSignature;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.NotImplementedException;

public class ObjectMethod
extends ObjectActionHandler
implements HandlerHolder,
WithTypeSignature {
    public final VarPattern handler;
    private final StateHolder holder;
    private ObjectDefn od;
    private Implements impl;
    private ContractMethodDecl contractMethod;
    private EventHolder eventCard;
    private List<Template> eventSources = new ArrayList<Template>();
    private List<Type> eventSourceTypes = new ArrayList<Type>();
    public boolean generate = true;
    private boolean broken;

    public ObjectMethod(InputPosition location, FunctionName name, List<Pattern> args, VarPattern handler, StateHolder holder) {
        super(location, name, args);
        this.handler = handler;
        this.holder = holder;
        for (Pattern p : this.args()) {
            p.isDefinedBy(this);
        }
    }

    public void dontGenerate() {
        this.generate = false;
    }

    @Override
    public boolean generate() {
        return this.generate;
    }

    @Override
    public void clean() {
        if (this.generate) {
            super.clean();
            this.eventSources.clear();
            this.eventSourceTypes.clear();
        }
    }

    public void eventFor(EventHolder card) {
        this.eventCard = card;
    }

    public void eventSource(Template t) {
        this.eventSources.add(t);
    }

    public List<Template> eventSourceExprs() {
        return this.eventSources;
    }

    public void bindEventSource(Type t) {
        this.eventSourceTypes.add(t);
    }

    public List<Type> sources() {
        if (this.eventSources.size() != this.eventSourceTypes.size()) {
            throw new NotImplementedException("I don't think the event sources have been typechecked");
        }
        return this.eventSourceTypes;
    }

    public void bindToObject(ObjectDefn od) {
        this.od = od;
    }

    public void bindToImplements(Implements implements1) {
        this.impl = implements1;
    }

    public void bindFromContract(ContractMethodDecl cm) {
        this.contractMethod = cm;
    }

    @Override
    public boolean hasObject() {
        return this.od != null;
    }

    @Override
    public ObjectDefn getObject() {
        if (this.od == null) {
            throw new NotImplementedException("There is no object definition bound here");
        }
        return this.od;
    }

    @Override
    public boolean hasImplements() {
        return this.impl != null;
    }

    @Override
    public Implements getImplements() {
        if (this.impl == null) {
            throw new NotImplementedException("There is no impl definition bound here");
        }
        return this.impl;
    }

    @Override
    public boolean isEvent() {
        return this.eventCard != null;
    }

    @Override
    public EventHolder getCard() {
        return this.eventCard;
    }

    @Override
    public VarPattern handler() {
        return this.handler;
    }

    @Override
    public String signature() {
        throw new NotImplementedException();
    }

    public String toString() {
        return "method " + this.name().uniqueName() + "(" + this.args().size() + ")";
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println("ObjectMethod[" + this.toString() + "]");
    }

    @Override
    public ContractMethodDecl contractMethod() {
        return this.contractMethod;
    }

    @Override
    public boolean hasState() {
        return this.holder != null;
    }

    @Override
    public StateHolder state() {
        return this.holder;
    }

    public boolean isTrulyStandalone() {
        return this.holder == null && this.impl == null;
    }

    public boolean isStandalone() {
        return this.impl == null && this.eventCard == null && this.od == null;
    }

    public void broke() {
        this.broken = true;
    }

    public boolean isBroken() {
        return this.broken;
    }
}

