/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.AsString;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.parsedForm.AccessorHolder;
import org.flasck.flas.parsedForm.EventHolder;
import org.flasck.flas.parsedForm.FieldAccessor;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.ObjectAccessor;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.PolyHolder;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.Template;
import org.flasck.flas.parser.ObjectElementsConsumer;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.Type;
import org.flasck.flas.tc3.UnifiableType;
import org.zinutils.exceptions.CantHappenException;

public class ObjectDefn
implements AsString,
Locatable,
ObjectElementsConsumer,
RepositoryEntry,
NamedType,
AccessorHolder,
StateHolder,
EventHolder,
PolyHolder {
    private StateDefinition state;
    public final List<Template> templates = new ArrayList<Template>();
    public final List<ObjectContract> contracts = new ArrayList<ObjectContract>();
    public final List<ObjectCtor> ctors = new ArrayList<ObjectCtor>();
    public final List<ObjectAccessor> acors = new ArrayList<ObjectAccessor>();
    public final List<ObjectMethod> methods = new ArrayList<ObjectMethod>();
    public final List<HandlerImplements> handlers = new ArrayList<HandlerImplements>();
    protected final List<PolyType> polys;
    private final Map<String, Integer> methodCases = new HashMap<String, Integer>();
    public final List<ObjectMethod> eventHandlers = new ArrayList<ObjectMethod>();
    protected final InputPosition location;
    private final SolidName name;
    public final InputPosition kw;
    public final boolean generate;

    public ObjectDefn(InputPosition kw, InputPosition location, SolidName tn, boolean generate, List<PolyType> polys) {
        this.kw = kw;
        this.name = tn;
        this.location = location;
        this.generate = generate;
        this.polys = polys;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public int templatePosn() {
        return this.templates.size();
    }

    @Override
    public FieldAccessor getAccessor(String called) {
        for (ObjectAccessor ret : this.acors) {
            if (!ret.name().name.equals(called)) continue;
            return ret;
        }
        return null;
    }

    public ObjectActionHandler getConstructor(String called) {
        for (ObjectActionHandler objectActionHandler : this.ctors) {
            if (!objectActionHandler.name().name.equals("_ctor_" + called)) continue;
            return objectActionHandler;
        }
        return null;
    }

    public ObjectMethod getMethod(String called) {
        for (ObjectMethod ret : this.methods) {
            if (!ret.name().name.equals(called)) continue;
            return ret;
        }
        return null;
    }

    public Template getTemplate(String var) {
        for (Template t : this.templates) {
            if (!t.name().baseName().equals(var)) continue;
            return t;
        }
        return null;
    }

    @Override
    public ObjectDefn defineState(StateDefinition state) {
        if (this.state != null) {
            throw new RuntimeException("Fix this case with a test");
        }
        this.state = state;
        return this;
    }

    @Override
    public StateDefinition state() {
        return this.state;
    }

    @Override
    public List<Template> templates() {
        return this.templates;
    }

    @Override
    public ObjectElementsConsumer requireContract(ObjectContract oc) {
        this.contracts.add(oc);
        return this;
    }

    @Override
    public ObjectElementsConsumer addTemplate(Template template) {
        this.templates.add(template);
        return this;
    }

    @Override
    public ObjectElementsConsumer addEventHandler(ObjectMethod handler) {
        this.eventHandlers.add(handler);
        return this;
    }

    @Override
    public ObjectDefn addConstructor(ObjectCtor ctor) {
        this.ctors.add(ctor);
        return this;
    }

    @Override
    public ObjectDefn addAccessor(ObjectAccessor m) {
        this.acors.add(m);
        return this;
    }

    @Override
    public void addMethod(ObjectMethod m) {
        this.methods.add(m);
        m.bindToObject(this);
    }

    @Override
    public void newHandler(ErrorReporter errors, HandlerImplements hi) {
        this.handlers.add(hi);
    }

    @Override
    public void complete(ErrorReporter errors, InputPosition location) {
        if (this.ctors.isEmpty()) {
            errors.message(this.location(), "objects must have at least one constructor");
        }
    }

    @Override
    public SolidName name() {
        return this.name;
    }

    @Override
    public boolean hasPolys() {
        return this.polys != null && !this.polys.isEmpty();
    }

    @Override
    public List<PolyType> polys() {
        return this.polys;
    }

    @Override
    public String asString() {
        StringBuilder sb = new StringBuilder(this.name().uniqueName());
        if (this.hasPolys()) {
            sb.append("[");
            String sep = "";
            for (int i = 0; i < this.polys().size(); ++i) {
                sb.append(sep);
                sb.append(this.polys().get(i));
                sep = ",";
            }
            sb.append("]");
        }
        return sb.toString();
    }

    public int caseFor(String name) {
        int ret = 0;
        if (this.methodCases.containsKey(name)) {
            ret = this.methodCases.get(name);
        }
        this.methodCases.put(name, ret + 1);
        return ret;
    }

    @Override
    public String signature() {
        return this.name.uniqueName();
    }

    @Override
    public int argCount() {
        throw new CantHappenException("you can't call an object definition directly - you need to use a constructor");
    }

    @Override
    public Type get(int pos) {
        throw new CantHappenException("you can't call an object definition directly - you need to use a constructor");
    }

    @Override
    public boolean incorporates(InputPosition pos, Type other) {
        if (other instanceof UnifiableType) {
            ((UnifiableType)other).incorporatedBy(pos, this);
            return true;
        }
        return this == other;
    }

    public String toString() {
        return "ObjectDefinition[" + this.asString() + "]";
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println(this.toString());
    }
}

