/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.hsi.ArgSlot;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.lifting.NestedVarReader;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.EventHolder;
import org.flasck.flas.parsedForm.FunctionConstness;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.GuardedMessagesConsumer;
import org.flasck.flas.parsedForm.Implements;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMessagesHolder;
import org.flasck.flas.parsedForm.PatternsHolder;
import org.flasck.flas.parsedForm.TypeBinder;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.ut.GuardedMessages;
import org.flasck.flas.parser.MethodMessagesConsumer;
import org.flasck.flas.patterns.HSITree;
import org.flasck.flas.repository.FunctionHSICases;
import org.flasck.flas.repository.HSICases;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public abstract class ObjectActionHandler
extends ObjectMessagesHolder
implements Locatable,
MethodMessagesConsumer,
GuardedMessagesConsumer,
RepositoryEntry,
LogicHolder,
PatternsHolder,
TypeBinder {
    private static final Logger logger = LoggerFactory.getLogger((String)"ObjectAH");
    private final InputPosition location;
    private final FunctionName name;
    private final List<Pattern> args;
    public final List<GuardedMessages> guards = new ArrayList<GuardedMessages>();
    private HSITree hsiTree;
    private Type type;
    private List<FunctionIntro> convertedIntros;
    private NestedVarReader nestedVars;
    private boolean reportHolder;
    private boolean dynamicType = false;
    private FunctionConstness constNess;

    public ObjectActionHandler(InputPosition location, FunctionName name, List<Pattern> args) {
        this.location = location;
        this.name = name;
        this.args = args;
    }

    @Override
    public void clean() {
        logger.info("Cleaning " + this.name);
        RepositoryEntry.super.clean();
        this.hsiTree = null;
        this.type = null;
        this.convertedIntros = null;
        this.nestedVars = null;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public FunctionName name() {
        return this.name;
    }

    @Override
    public boolean isMyName(NameOfThing other) {
        return other == this.name;
    }

    @Override
    public boolean isObjAccessor() {
        return false;
    }

    @Override
    public int compareTo(LogicHolder o) {
        return this.name().compareTo(o.name());
    }

    @Override
    public boolean hasArgs() {
        return !this.args.isEmpty();
    }

    @Override
    public List<Pattern> args() {
        return this.args;
    }

    @Override
    public int argCount() {
        int ret = this.args.size();
        if (this.reportHolder && this.hasState()) {
            ++ret;
        }
        if (this.nestedVars != null) {
            ret += this.nestedVars.size();
        }
        return ret;
    }

    public int argCountWithoutHolder() {
        int ret = this.args.size();
        if (this.nestedVars != null) {
            ret += this.nestedVars.size();
        }
        return ret;
    }

    @Override
    public void setConstness(FunctionConstness fc) {
        this.constNess = fc;
    }

    @Override
    public FunctionConstness constNess() {
        return this.constNess;
    }

    @Override
    public void guard(GuardedMessages gm) {
        this.guards.add(gm);
    }

    @Override
    public boolean hasMessages() {
        if (super.hasMessages()) {
            return true;
        }
        for (GuardedMessages gm : this.guards) {
            if (!gm.hasMessages()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void nestedVars(NestedVarReader nestedVars) {
        this.nestedVars = nestedVars;
    }

    @Override
    public NestedVarReader nestedVars() {
        return this.nestedVars;
    }

    public void bindHsi(HSITree hsiTree) {
        this.hsiTree = hsiTree;
    }

    @Override
    public HSITree hsiTree() {
        return this.hsiTree;
    }

    @Override
    public HSICases hsiCases() {
        if (this.convertedIntros == null) {
            throw new RuntimeException("Method has not been converted");
        }
        return new FunctionHSICases(this.convertedIntros);
    }

    @Override
    public List<Slot> slots() {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.hsiTree.width(); ++i) {
            slots.add(new ArgSlot(i, this.hsiTree.get(i)));
        }
        return slots;
    }

    public void conversion(List<FunctionIntro> convertedIntros) {
        this.convertedIntros = convertedIntros;
    }

    public boolean isConverted() {
        return this.convertedIntros != null;
    }

    public List<FunctionIntro> converted() {
        if (this.convertedIntros == null) {
            throw new NotImplementedException("there is no converted function");
        }
        return this.convertedIntros;
    }

    @Override
    public void bindType(Type ty) {
        if (this.type != null) {
            throw new RuntimeException("Cannot bind type of " + this.name + " more than once");
        }
        this.type = ty;
    }

    public boolean hasType() {
        return this.type != null;
    }

    @Override
    public Type type() {
        if (this.dynamicType) {
            throw new CantHappenException("To resolve dynamic types, use resolveType");
        }
        if (this.type == null) {
            throw new RuntimeException("Type not bound for " + this.name.uniqueName());
        }
        return this.type;
    }

    public void dynamicallyType() {
        this.dynamicType = true;
    }

    public Type resolveType(RepositoryReader repository) {
        if (!this.dynamicType) {
            return this.type();
        }
        if (this.args.isEmpty()) {
            return this.getObject();
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (Pattern p : this.args) {
            if (p instanceof TypedPattern) {
                TypedPattern tp = (TypedPattern)p;
                types.add(tp.type.resolveType(repository));
                continue;
            }
            throw new NotImplementedException("not a typed pattern");
        }
        types.add(this.getObject());
        return new Apply(types);
    }

    public void reportHolderInArgCount() {
        this.reportHolder = true;
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println("ObjectCtor[" + this.toString() + "]");
    }

    @Override
    public abstract boolean hasState();

    public abstract boolean hasObject();

    public abstract boolean hasImplements();

    public abstract boolean isEvent();

    public abstract ObjectDefn getObject();

    public abstract Implements getImplements();

    public abstract EventHolder getCard();

    public abstract ContractMethodDecl contractMethod();
}

