/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.HandlerName;
import org.flasck.flas.lifting.NestedVarReader;
import org.flasck.flas.parsedForm.HandlerLambda;
import org.flasck.flas.parsedForm.Implements;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.StateDefinition;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parsedForm.WithTypeSignature;
import org.flasck.flas.patterns.HSIOptions;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class HandlerImplements
extends Implements
implements RepositoryEntry,
NamedType,
WithTypeSignature,
StateHolder {
    public final String baseName;
    public final List<HandlerLambda> boundVars;
    public final boolean inCard;
    public final InputPosition typeLocation;
    public final HandlerName handlerName;

    public HandlerImplements(InputPosition kw, InputPosition location, InputPosition typeLocation, NamedType parent, HandlerName handlerName, TypeReference implementing, boolean inCard, List<HandlerLambda> lambdas) {
        super(kw, location, parent, implementing, handlerName);
        this.typeLocation = typeLocation;
        this.handlerName = handlerName;
        this.baseName = handlerName.baseName;
        this.inCard = inCard;
        this.boundVars = lambdas;
    }

    @Override
    public String signature() {
        return this.handlerName.uniqueName();
    }

    @Override
    public int argCount() {
        return this.boundVars.size();
    }

    @Override
    public Type get(int pos) {
        if (pos == this.boundVars.size()) {
            return this;
        }
        HandlerLambda hl = this.boundVars.get(pos);
        if (hl.patt instanceof TypedPattern) {
            return ((TypedPattern)hl.patt).type();
        }
        if (hl.patt instanceof VarPattern) {
            if (hl.isNested) {
                return hl.unifiableType();
            }
            throw new NotImplementedException("Cannot handle var pattern in non-nested lambda: " + hl.patt);
        }
        throw new NotImplementedException("Pattern not handled: " + hl.getClass());
    }

    public ObjectMethod getMethod(String called) {
        for (ObjectMethod m : this.implementationMethods) {
            if (!m.name().name.equals(called)) continue;
            return m;
        }
        return null;
    }

    @Override
    public boolean incorporates(InputPosition pos, Type other) {
        return this == other;
    }

    @Override
    public Type type() {
        return this;
    }

    @Override
    public StateDefinition state() {
        if (this.parent instanceof StateHolder) {
            return ((StateHolder)((Object)this.parent)).state();
        }
        throw new NotImplementedException();
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println(this.toString());
    }

    public NestedVarReader nestedVars() {
        if (this.boundVars != null && !this.boundVars.isEmpty() && this.boundVars.get((int)0).isNested) {
            return new AsNested();
        }
        return null;
    }

    @Override
    public String toString() {
        return "HandlerImplements[" + this.handlerName.uniqueName() + "]";
    }

    public class AsNested
    implements NestedVarReader {
        @Override
        public int size() {
            int ret = 0;
            for (HandlerLambda hl : HandlerImplements.this.boundVars) {
                if (!hl.isNested) continue;
                ++ret;
            }
            return ret;
        }

        @Override
        public Collection<HSIOptions> all() {
            throw new NotImplementedException();
        }

        @Override
        public List<UnresolvedVar> vars() {
            ArrayList<UnresolvedVar> ret = new ArrayList<UnresolvedVar>();
            for (HandlerLambda hl : HandlerImplements.this.boundVars) {
                UnresolvedVar uv;
                if (!hl.isNested) continue;
                if (hl.patt instanceof TypedPattern) {
                    TypedPattern tp = (TypedPattern)hl.patt;
                    uv = new UnresolvedVar(hl.location(), tp.var.var);
                    uv.bind(tp);
                    ret.add(uv);
                    continue;
                }
                if (hl.patt instanceof VarPattern) {
                    VarPattern vp = (VarPattern)hl.patt;
                    uv = new UnresolvedVar(hl.location(), vp.var);
                    uv.bind(vp);
                    ret.add(uv);
                    continue;
                }
                throw new CantHappenException("cannot have a pattern " + hl.patt.getClass());
            }
            return ret;
        }

        @Override
        public List<Pattern> patterns() {
            throw new NotImplementedException();
        }

        @Override
        public boolean containsReferencesNotIn(Set<LogicHolder> processedFns) {
            throw new NotImplementedException();
        }

        @Override
        public Set<LogicHolder> references() {
            throw new NotImplementedException();
        }

        @Override
        public Set<HandlerImplements> referencesHI() {
            throw new NotImplementedException();
        }

        @Override
        public Set<LogicHolder> referencesHIMethods() {
            throw new NotImplementedException();
        }

        @Override
        public boolean enhanceWith(LogicHolder fn, NestedVarReader nestedVars) {
            throw new NotImplementedException();
        }

        @Override
        public boolean dependsOn(LogicHolder f) {
            throw new NotImplementedException();
        }

        @Override
        public void bindLambda(int which, HandlerLambda hl) {
            throw new NotImplementedException();
        }

        @Override
        public void clearPatterns() {
            throw new NotImplementedException();
        }
    }
}

