/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.commonBase.names.SolidName;
import org.flasck.flas.compiler.UnboundTypeException;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.hsi.ArgSlot;
import org.flasck.flas.hsi.Slot;
import org.flasck.flas.lifting.NestedVarReader;
import org.flasck.flas.parsedForm.AccessRestrictions;
import org.flasck.flas.parsedForm.FunctionConstness;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.PolyType;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.TypeBinder;
import org.flasck.flas.parsedForm.WithTypeSignature;
import org.flasck.flas.patterns.HSITree;
import org.flasck.flas.repository.FunctionHSICases;
import org.flasck.flas.repository.HSICases;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tc3.Type;

public class FunctionDefinition
implements RepositoryEntry,
Locatable,
WithTypeSignature,
LogicHolder,
Comparable<LogicHolder>,
TypeBinder,
AccessRestrictions {
    private final FunctionName name;
    private final int nargs;
    private final StateHolder holder;
    private final List<FunctionIntro> intros = new ArrayList<FunctionIntro>();
    private final Map<String, PolyType> namedPolys = new TreeMap<String, PolyType>();
    private Type type;
    private HSITree hsiTree;
    private NestedVarReader nestedVars;
    private boolean reportHolder;
    private AccessRestrictions restricted;
    private boolean isObjAccessor;
    public boolean generate = true;
    private List<Slot> slots;
    private FunctionConstness constNess;

    public FunctionDefinition(FunctionName name, int nargs, StateHolder holder) {
        this.name = name;
        this.nargs = nargs;
        this.holder = holder;
    }

    public FunctionDefinition dontGenerate() {
        this.generate = false;
        return this;
    }

    @Override
    public boolean generate() {
        return this.generate;
    }

    public void intro(FunctionIntro next) {
        this.intros.add(next);
        this.attachMeToPatternVars(next);
    }

    @Override
    public FunctionName name() {
        return this.name;
    }

    @Override
    public boolean isMyName(NameOfThing other) {
        if (other == this.name) {
            return true;
        }
        for (FunctionIntro fi : this.intros) {
            if (other != fi.name()) continue;
            return true;
        }
        return false;
    }

    @Override
    public InputPosition location() {
        if (this.intros.isEmpty()) {
            return this.name.location;
        }
        return this.intros.get((int)0).location;
    }

    @Override
    public boolean hasArgs() {
        return this.argCountWithoutHolder() > 0;
    }

    @Override
    public int argCount() {
        int ret = this.nargs;
        if (this.reportHolder && this.holder != null) {
            ++ret;
        }
        if (this.nestedVars != null) {
            ret += this.nestedVars.size();
        }
        return ret;
    }

    public int argCountWithoutHolder() {
        int ret = this.nargs;
        if (this.nestedVars != null) {
            ret += this.nestedVars.size();
        }
        return ret;
    }

    @Override
    public String signature() {
        return this.type.signature();
    }

    public List<FunctionIntro> intros() {
        return this.intros;
    }

    @Override
    public HSICases hsiCases() {
        return new FunctionHSICases(this.intros);
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println(this.toString());
    }

    public String toString() {
        return "fn " + this.name.uniqueName() + "(" + (this.holder != null ? "+" : "") + this.nargs + ")";
    }

    @Override
    public void bindType(Type ty) {
        this.type = ty;
    }

    public boolean hasType() {
        return this.type != null;
    }

    @Override
    public Type type() {
        if (this.type == null) {
            throw new UnboundTypeException(this);
        }
        return this.type;
    }

    public void bindHsi(HSITree hsiTree) {
        this.hsiTree = hsiTree;
        this.slots = new ArrayList<Slot>();
        for (int i = 0; i < hsiTree.width(); ++i) {
            this.slots.add(new ArgSlot(i, hsiTree.get(i)));
        }
    }

    @Override
    public HSITree hsiTree() {
        return this.hsiTree;
    }

    @Override
    public List<Slot> slots() {
        return this.slots;
    }

    @Override
    public void nestedVars(NestedVarReader nestedVars) {
        this.nestedVars = nestedVars;
    }

    @Override
    public NestedVarReader nestedVars() {
        return this.nestedVars;
    }

    @Override
    public int compareTo(LogicHolder o) {
        return this.name().compareTo(o.name());
    }

    private void attachMeToPatternVars(FunctionIntro fi) {
        for (Pattern p : fi.args) {
            p.isDefinedBy(this);
        }
    }

    @Override
    public boolean hasState() {
        return this.holder != null;
    }

    @Override
    public StateHolder state() {
        return this.holder;
    }

    public void reportHolderInArgCount() {
        this.reportHolder = true;
    }

    @Override
    public void setConstness(FunctionConstness fc) {
        this.constNess = fc;
    }

    @Override
    public FunctionConstness constNess() {
        return this.constNess;
    }

    public void restrict(AccessRestrictions r) {
        this.restricted = r;
    }

    @Override
    public void check(ErrorReporter errors, InputPosition pos, NameOfThing inContext) {
        if (this.restricted != null) {
            this.restricted.check(errors, pos, inContext);
        }
    }

    @Override
    public boolean isObjAccessor() {
        return this.isObjAccessor;
    }

    public void isObjAccessor(boolean b) {
        this.isObjAccessor = b;
    }

    public PolyType allocatePoly(InputPosition pos, String tn) {
        if (this.namedPolys.containsKey(tn)) {
            return this.namedPolys.get(tn);
        }
        PolyType pt = new PolyType(pos, new SolidName(this.name, tn));
        this.namedPolys.put(tn, pt);
        return pt;
    }
}

