/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.commonBase.names.NameOfThing;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.tc3.Apply;
import org.flasck.flas.tc3.Type;

public class ContractMethodDecl
implements Locatable,
RepositoryEntry,
Comparable<ContractMethodDecl> {
    public final InputPosition rkw;
    public final InputPosition dkw;
    private final InputPosition pos;
    public final boolean required;
    public final FunctionName name;
    public final List<TypedPattern> args;
    private Type type;
    public final TypedPattern handler;

    public ContractMethodDecl(InputPosition rkw, InputPosition dkw, InputPosition pos, boolean required, FunctionName name, List<TypedPattern> args, TypedPattern handler) {
        this.rkw = rkw;
        this.dkw = dkw;
        this.pos = pos;
        this.required = required;
        this.name = name;
        this.args = args;
        this.handler = handler;
    }

    @Override
    public int compareTo(ContractMethodDecl o) {
        return this.name.compareTo(o.name);
    }

    public void bindType() {
        if (this.type != null) {
            throw new RuntimeException("Type already bound to " + this.type + " cannot rebind");
        }
        ArrayList<Type> types = new ArrayList<Type>();
        for (Pattern pattern : this.args) {
            Type ty = ((TypedPattern)pattern).type();
            if (ty == null) {
                return;
            }
            types.add(ty);
        }
        boolean withHandler = false;
        if (this.handler != null) {
            if (this.handler.type() == null) {
                return;
            }
            types.add(this.handler.type());
            withHandler = true;
        } else {
            types.add(LoadBuiltins.idempotentHandler);
        }
        this.type = new Apply(types, (Type)LoadBuiltins.send).withHandler(withHandler);
    }

    public Type type() {
        return this.type;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.required ? "required" : "optional");
        sb.append(" ");
        sb.append(this.name.uniqueName());
        for (TypedPattern o : this.args) {
            sb.append(" ");
            sb.append(((Object)o).toString());
        }
        return sb.toString();
    }

    @Override
    public InputPosition location() {
        return this.pos;
    }

    @Override
    public NameOfThing name() {
        return this.name;
    }

    @Override
    public void dumpTo(PrintWriter pw) {
        pw.println(this.toString());
    }
}

