/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.parsedForm;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.parsedForm.LogicHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.zinutils.exceptions.NotImplementedException;

public class ConstructorMatch
implements Pattern {
    public final String ctor;
    public final List<Field> args = new ArrayList<Field>();
    private InputPosition location;
    private StructDefn defn;
    private LogicHolder definedBy;

    public ConstructorMatch(InputPosition loc, String ctor) {
        if (loc == null) {
            System.out.println("null position cm1");
        }
        this.location = loc;
        this.ctor = ctor;
    }

    @Override
    public LogicHolder definedBy() {
        return this.definedBy;
    }

    @Override
    public void isDefinedBy(LogicHolder definedBy) {
        this.definedBy = definedBy;
        for (Field f : this.args) {
            f.patt.isDefinedBy(definedBy);
        }
    }

    public ConstructorMatch bind(StructDefn defn) {
        this.defn = defn;
        return this;
    }

    public StructDefn actual() {
        if (this.defn == null) {
            throw new NotImplementedException("Not resolved: " + this.ctor);
        }
        return this.defn;
    }

    @Override
    public InputPosition location() {
        return this.location;
    }

    @Override
    public Pattern locatedAt(InputPosition location) {
        this.location = location;
        return this;
    }

    public String toString() {
        StringBuilder ret = new StringBuilder(this.ctor);
        if (!this.args.isEmpty()) {
            ret.append(" { ");
            for (Field f : this.args) {
                ret.append(f.field + ": " + f.patt + " ");
            }
            ret.append("}");
        }
        return ret.toString();
    }

    public class Field
    implements Locatable {
        public final String field;
        public final Pattern patt;
        private InputPosition loc;

        public Field(InputPosition loc, String field, Pattern patt) {
            this.loc = loc;
            this.field = field;
            this.patt = patt;
        }

        @Override
        public InputPosition location() {
            return this.loc;
        }

        public String toString() {
            return "CMF[" + this.field + "]";
        }
    }
}

