/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.method;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.method.MemberExprConvertor;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.zinutils.exceptions.NotImplementedException;

public class UDDConvertor
extends LeafAdapter
implements ResultAware {
    private final NestedVisitor nv;
    private final ErrorReporter errors;
    private final List<Object> stack = new ArrayList<Object>();
    private MemberExpr convert;

    public UDDConvertor(NestedVisitor sv, ErrorReporter errors) {
        this.nv = sv;
        this.errors = errors;
        sv.push(this);
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        if (expr instanceof ApplyExpr) {
            new UDDConvertor(this.nv, this.errors);
        } else if (expr instanceof MemberExpr) {
            this.convert = (MemberExpr)expr;
        } else {
            this.stack.add(expr);
        }
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        new MemberExprConvertor(this.errors, this.nv, null, this.convert);
        return false;
    }

    @Override
    public void result(Object r) {
        if (this.convert != null) {
            this.convert.conversion((Expr)r);
            this.convert = null;
        }
        this.stack.add(r);
    }

    @Override
    public void leaveApplyExpr(ApplyExpr expr) {
        Object op = this.stack.remove(0);
        this.nv.result(new ApplyExpr(expr.location(), op, this.stack));
    }

    @Override
    public void leaveUnitDataDeclaration(UnitDataDeclaration udd) {
        if (this.stack.size() == 1) {
            this.stack.remove(0);
        }
        if (!this.stack.isEmpty()) {
            throw new NotImplementedException("the stack should be empty");
        }
        this.nv.result(null);
    }
}

