/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.method;

import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.method.MemberExprConvertor;
import org.flasck.flas.method.MessageConvertor;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.TypeExpr;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.NamedType;
import org.zinutils.exceptions.HaventConsideredThisException;

public class SpecialConvertor
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final NestedVisitor nv;
    private final ObjectActionHandler oah;
    private TypeReference ty;
    private Expr value;

    public SpecialConvertor(ErrorReporter errors, NestedVisitor nv, ObjectActionHandler oah, AssignMessage assign) {
        this.errors = errors;
        this.nv = nv;
        this.oah = oah;
        nv.push(this);
    }

    @Override
    public void visitTypeReference(TypeReference var, boolean expectPolys, int exprNargs) {
        this.ty = var;
    }

    @Override
    public void visitApplyExpr(ApplyExpr expr) {
        this.nv.push(new MessageConvertor(this.errors, this.nv, this.oah, null));
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (expr.boundEarly()) {
            NamedType nt = (NamedType)((Object)expr.defn());
            TypeReference tr = new TypeReference(expr.location, nt.name().baseName(), new TypeReference[0]);
            tr.bind(nt);
            this.ty = tr;
            return true;
        }
        new MemberExprConvertor(this.errors, this.nv, this.oah, expr);
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void result(Object r) {
        if (this.ty == null) {
            if (!(r instanceof TypeReference)) throw new HaventConsideredThisException((r instanceof Locatable ? ((Locatable)r).location().toString() : "") + r + " is not handled");
            this.ty = (TypeReference)r;
            return;
        } else {
            if (this.value != null) return;
            this.value = (Expr)r;
        }
    }

    @Override
    public void leaveTypeExpr(TypeExpr expr) {
        if (this.ty == null) {
            this.nv.result(expr);
        } else {
            this.nv.result(new TypeExpr(expr.location, expr.tyLoc, this.ty));
        }
    }

    @Override
    public void leaveCastExpr(CastExpr expr) {
        if (this.ty == null || this.value == null) {
            this.nv.result(expr);
        } else {
            this.nv.result(new CastExpr(expr.location, expr.tyLoc, expr.valLoc, this.ty, this.value));
        }
    }
}

