/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.method;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.Pattern;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.method.MemberExprConvertor;
import org.flasck.flas.method.MessageConvertor;
import org.flasck.flas.parsedForm.ActionMessage;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.FunctionCaseDefn;
import org.flasck.flas.parsedForm.FunctionIntro;
import org.flasck.flas.parsedForm.Messages;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.ut.GuardedMessages;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;

public class MethodConvertor
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final NestedVisitor sv;
    private final List<Expr> results = new ArrayList<Expr>();
    private ObjectActionHandler oah;
    private final FunctionIntro fi;
    private boolean msgHasGuard = false;
    private boolean haveGuards = false;

    public MethodConvertor(ErrorReporter errors, NestedVisitor sv, ObjectActionHandler oah) {
        this.fi = new FunctionIntro(oah.name(), new ArrayList<Pattern>());
        this.errors = errors;
        this.sv = sv;
        this.oah = oah;
    }

    @Override
    public void visitGuardedMessage(GuardedMessages gm) {
        this.haveGuards = true;
        this.msgHasGuard = false;
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        if (!this.haveGuards) {
            return;
        }
        this.msgHasGuard = true;
        if (!(expr instanceof ApplyExpr) && !(expr instanceof MemberExpr)) {
            this.results.add(expr);
        }
    }

    @Override
    public void visitApplyExpr(ApplyExpr expr) {
        if (this.haveGuards) {
            this.sv.push(new MessageConvertor(this.errors, this.sv, this.oah, null));
        }
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (this.haveGuards) {
            new MemberExprConvertor(this.errors, this.sv, this.oah, expr);
        }
        return false;
    }

    @Override
    public void visitMessage(ActionMessage msg) {
        this.sv.push(new MessageConvertor(this.errors, this.sv, this.oah, msg instanceof AssignMessage ? (AssignMessage)msg : null));
    }

    @Override
    public void result(Object r) {
        this.results.add((Expr)r);
    }

    @Override
    public void leaveGuardedMessage(GuardedMessages gm) {
        Expr guard = null;
        if (this.msgHasGuard) {
            guard = this.results.remove(0);
        }
        this.fi.functionCase(new FunctionCaseDefn(this.oah.location(), this.fi, guard, new Messages(this.oah.location(), new ArrayList<Expr>(this.results))));
        this.results.clear();
    }

    @Override
    public void leaveObjectMethod(ObjectMethod meth) {
        if (!this.haveGuards) {
            this.fi.functionCase(new FunctionCaseDefn(this.oah.location(), this.fi, null, new Messages(meth.location(), this.results)));
        }
        meth.conversion(Arrays.asList(this.fi));
        this.sv.result(null);
    }

    @Override
    public void leaveObjectCtor(ObjectCtor meth) {
        if (!this.haveGuards) {
            this.fi.functionCase(new FunctionCaseDefn(this.oah.location(), this.fi, null, new Messages(meth.location(), this.results)));
        }
        meth.conversion(Arrays.asList(this.fi));
        this.sv.result(null);
    }
}

