/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.method;

import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.method.CheckNoMessages;
import org.flasck.flas.method.MemberExprConvertor;
import org.flasck.flas.method.SpecialConvertor;
import org.flasck.flas.parsedForm.ActionMessage;
import org.flasck.flas.parsedForm.AssignMessage;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.CurrentContainer;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.ImplementsContract;
import org.flasck.flas.parsedForm.MakeSend;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.SendMessage;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TypeExpr;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.ut.UnitTestInvoke;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.repository.Traverser;
import org.flasck.flas.tc3.NamedType;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.NotImplementedException;

public class MessageConvertor
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final NestedVisitor nv;
    private final ObjectActionHandler oah;
    private final AssignMessage assign;
    private final List<Object> stack = new ArrayList<Object>();
    private Mode mode = Mode.RHS;
    private Expr slotContainer;

    public MessageConvertor(ErrorReporter errors, NestedVisitor nv, ObjectActionHandler oah, AssignMessage assign) {
        this.errors = errors;
        this.nv = nv;
        this.oah = oah;
        this.assign = assign;
    }

    @Override
    public void leaveSendHandler(Expr handlerExpr) {
        Expr h;
        if (this.stack.size() != 2) {
            throw new CantHappenException("when we have a handler, there should be two items on the stack");
        }
        Object sr = this.stack.get(0);
        if (sr instanceof MakeSend) {
            ms = (MakeSend)sr;
        } else if (sr instanceof ApplyExpr) {
            ms = (MakeSend)((ApplyExpr)sr).fn;
        } else {
            throw new NotImplementedException();
        }
        ms.handler = h = (Expr)this.stack.remove(1);
    }

    @Override
    public void visitExpr(Expr expr, int nArgs) {
        if (!(expr instanceof ApplyExpr) && !(expr instanceof MemberExpr)) {
            if (this.mode == Mode.RHS) {
                if (expr instanceof CastExpr || expr instanceof TypeExpr) {
                    new SpecialConvertor(this.errors, this.nv, this.oah, this.assign);
                } else {
                    this.stack.add(expr);
                }
            } else if (this.mode == Mode.SLOT && this.assign.assignsToCons()) {
                this.slotContainer = expr;
                this.mode = Mode.HAVESLOT;
            }
        }
    }

    @Override
    public void visitApplyExpr(ApplyExpr expr) {
        this.nv.push(new MessageConvertor(this.errors, this.nv, this.oah, null));
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (expr.boundEarly()) {
            UnresolvedVar uv = new UnresolvedVar(expr.location, expr.asName());
            uv.bind(expr.defn());
            this.stack.add(uv);
            return true;
        }
        if (this.mode == Mode.SLOT) {
            this.mode = Mode.NESTEDSLOT;
            if (!(expr.from instanceof MemberExpr)) {
                this.slotContainer = expr.from;
            }
        } else if (this.mode == Mode.NESTEDSLOT || this.mode == Mode.RHS) {
            new MemberExprConvertor(this.errors, this.nv, this.oah, expr);
        } else {
            throw new CantHappenException("shouldn't see ME in mode " + this.mode);
        }
        return false;
    }

    @Override
    public void visitAssignSlot(Expr slot) {
        this.mode = Mode.SLOT;
    }

    @Override
    public void result(Object r) {
        if (this.mode == Mode.RHS || this.mode == Mode.SUBSCRIBERNAME) {
            this.stack.add((Expr)r);
        } else {
            if (this.slotContainer != null) {
                throw new NotImplementedException();
            }
            this.slotContainer = (Expr)r;
        }
    }

    @Override
    public void leaveAssignMessage(AssignMessage msg) {
        UnresolvedVar op;
        UnresolvedVar inner;
        if (this.stack.size() != 1) {
            throw new NotImplementedException("stack size should be 1 but was " + this.stack.size());
        }
        Expr expr = (Expr)this.stack.remove(0);
        ArrayList<Object> args = new ArrayList<Object>();
        if (this.slotContainer == null) {
            inner = (UnresolvedVar)msg.slot;
            NamedType nt = (NamedType)((Object)this.oah.state());
            if (nt instanceof ImplementsContract) {
                nt = ((ImplementsContract)nt).getParent();
            } else if (nt instanceof HandlerImplements) {
                nt = ((HandlerImplements)nt).state();
            }
            args.add(new CurrentContainer(msg.kw, nt));
        } else if (this.slotContainer instanceof UnresolvedVar && msg.assignsToCons()) {
            inner = null;
            args.add(this.slotContainer);
        } else {
            inner = (UnresolvedVar)((MemberExpr)msg.slot).fld;
            args.add(this.slotContainer);
        }
        if (msg.assignsToCons()) {
            op = new UnresolvedVar(msg.kw, "AssignCons");
            op.bind(LoadBuiltins.assignCons);
        } else {
            op = new UnresolvedVar(msg.kw, "Assign");
            op.bind(LoadBuiltins.assign);
            args.add(new StringLiteral(inner.location, inner.var));
        }
        args.add(expr);
        this.stack.add(new ApplyExpr(msg.kw, (Object)op, args));
    }

    @Override
    public void leaveApplyExpr(ApplyExpr expr) {
        Object op = this.stack.remove(0);
        this.nv.result(new ApplyExpr(expr.location(), op, this.stack));
    }

    @Override
    public void leaveCastExpr(CastExpr expr) {
        this.nv.result(new CastExpr(expr.location(), expr.tyLoc, expr.valLoc, expr.type, (Expr)this.stack.remove(0)));
    }

    @Override
    public void leaveMemberExpr(MemberExpr expr, boolean done) {
        if (expr.boundEarly()) {
            return;
        }
        if (this.mode != Mode.NESTEDSLOT) {
            throw new CantHappenException("shouldn't see leaveMemberExpr in mode " + this.mode);
        }
        this.mode = Mode.HAVESLOT;
    }

    @Override
    public void leaveStructField(StructField sf) {
        if (this.stack.isEmpty()) {
            return;
        }
        if (this.stack.size() != 1) {
            throw new NotImplementedException("when sending messages, should only have 1 arg");
        }
        new Traverser(new CheckNoMessages(this.errors)).visitExpr(sf.init, 0);
        this.nv.result(null);
    }

    @Override
    public void visitSubscriberName(Expr expr) {
        this.mode = Mode.SUBSCRIBERNAME;
        this.nv.push(new MessageConvertor(this.errors, this.nv, this.oah, null));
    }

    @Override
    public void leaveSubscriberName(Expr handlerName) {
        this.nv.result(this.stack.remove(0));
    }

    @Override
    public void leaveSendMessage(SendMessage msg) {
        if (msg.subscriberName() != null) {
            Expr hn = (Expr)this.stack.remove(1);
            Expr ms = (Expr)this.stack.get(0);
            if (ms instanceof ApplyExpr) {
                ms = (MakeSend)((ApplyExpr)ms).fn;
            }
            ((MakeSend)ms).handlerName = hn;
        }
    }

    @Override
    public void leaveMessage(ActionMessage msg) {
        if (this.stack.size() != 1) {
            throw new NotImplementedException("when sending messages, should only have 1 arg");
        }
        this.nv.result(this.stack.remove(0));
    }

    @Override
    public void leaveUnitTestInvoke(UnitTestInvoke uti) {
        if (this.stack.size() != 1) {
            throw new NotImplementedException("should be 1");
        }
        uti.conversion((Expr)this.stack.remove(0));
        this.nv.result(null);
    }

    public static enum Mode {
        RHS,
        SLOT,
        NESTEDSLOT,
        HAVESLOT,
        SUBSCRIBERNAME;

    }
}

