/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.method;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.method.MessageConvertor;
import org.flasck.flas.parsedForm.AgentDefinition;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.ContractDecl;
import org.flasck.flas.parsedForm.ContractMethodDecl;
import org.flasck.flas.parsedForm.FieldAccessor;
import org.flasck.flas.parsedForm.HandlerImplements;
import org.flasck.flas.parsedForm.MakeAcor;
import org.flasck.flas.parsedForm.MakeSend;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.RequiresHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.ResultAware;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Primitive;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;
import org.zinutils.exceptions.ShouldBeError;

public class MemberExprConvertor
extends LeafAdapter
implements ResultAware {
    private final ErrorReporter errors;
    private final NestedVisitor nv;
    private final ObjectActionHandler oah;
    private Expr obj;
    private ContractDecl cd;
    private ObjectDefn od;
    private StructDefn sd;
    private HandlerImplements hi;
    private FunctionName sendMeth;
    private int expargs;
    private ObjectActionHandler odctor;
    private final Type containerType;
    private final Type containedType;
    private boolean isAcor;
    private FieldAccessor acorFrom;
    private final List<Object> results = new ArrayList<Object>();
    private Type entity;

    public MemberExprConvertor(ErrorReporter errors, NestedVisitor nv, ObjectActionHandler oah, MemberExpr me) {
        this.errors = errors;
        this.nv = nv;
        this.oah = oah;
        this.containerType = me.containerType();
        this.containedType = me.containedType();
        nv.push(this);
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (expr.boundEarly()) {
            return true;
        }
        new MemberExprConvertor(this.errors, this.nv, this.oah, expr);
        return false;
    }

    @Override
    public void visitCastExpr(CastExpr expr) {
        this.nv.push(new MessageConvertor(this.errors, this.nv, this.oah, null));
    }

    @Override
    public void visitTypeReference(TypeReference var, boolean expectPolys, int exprNargs) {
        if (this.obj != null) {
            throw new ShouldBeError("I don't think " + var + " can be a method");
        }
        this.obj = var;
        this.figureDestinationType();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void visitUnresolvedVar(UnresolvedVar var, int nargs) {
        if (this.obj == null) {
            this.obj = var;
            this.figureDestinationType();
            return;
        } else {
            if (this.sendMeth != null) throw new NotImplementedException("Too many arguments to MemberExpr");
            if (this.cd != null) {
                ContractMethodDecl cmd = this.cd.getMethod(var.var);
                if (cmd == null) {
                    throw new ShouldBeError("there is no method " + var.var + " on " + this.cd.name().uniqueName());
                }
                this.sendMeth = cmd.name;
                this.expargs = cmd.args.size();
                return;
            } else if (this.od != null) {
                FieldAccessor acor = this.od.getAccessor(var.var);
                ObjectActionHandler om = this.od.getMethod(var.var);
                if (om == null) {
                    this.odctor = om = this.od.getConstructor(var.var);
                }
                if (acor != null) {
                    this.isAcor = true;
                    this.sendMeth = FunctionName.function(var.location(), this.od.name(), var.var);
                    this.expargs = acor.acorArgCount();
                    return;
                } else {
                    if (om == null) {
                        throw new ShouldBeError("there is no accessor or method " + var.var + " on " + this.od.name().uniqueName());
                    }
                    this.sendMeth = om.name();
                    this.expargs = om.argCount();
                }
                return;
            } else if (this.sd != null) {
                if (this.containedType == LoadBuiltins.event && var.var.equals("source")) {
                    this.sendMeth = FunctionName.function(var.location(), null, "_eventSource");
                    this.expargs = 0;
                    return;
                } else {
                    FieldAccessor acor = this.sd.getAccessor(var.var);
                    if (acor == null) {
                        throw new NotImplementedException("There is no acor " + var.var);
                    }
                    this.acorFrom = acor;
                    this.expargs = 0;
                }
                return;
            } else if (this.entity != null) {
                if (!var.var.equals("id")) throw new CantHappenException("you can only extract id from entity");
                this.acorFrom = LoadBuiltins.idAccessor;
                this.expargs = 0;
                return;
            } else {
                if (this.hi == null) throw new NotImplementedException("Need to implement the field case");
                ObjectMethod hm = this.hi.getMethod(var.var);
                if (hm == null) {
                    throw new ShouldBeError("there is no accessor or method " + var.var + " on " + this.od.name().uniqueName());
                }
                this.sendMeth = hm.name();
                this.expargs = hm.argCount();
            }
        }
    }

    @Override
    public void result(Object r) {
        this.results.add(r);
    }

    private void figureDestinationType() {
        Type ct = this.containerType;
        if (ct instanceof PolyInstance) {
            PolyInstance pi = (PolyInstance)ct;
            ct = pi.struct();
        }
        if (ct instanceof ContractDecl) {
            this.cd = (ContractDecl)ct;
        } else if (ct instanceof ObjectDefn) {
            this.od = (ObjectDefn)ct;
        } else if (ct instanceof StructDefn) {
            this.sd = (StructDefn)ct;
        } else if (ct instanceof Primitive && ct.signature().equals("Entity")) {
            this.entity = ct;
        } else if (ct instanceof HandlerImplements) {
            this.hi = (HandlerImplements)ct;
        } else {
            throw new NotImplementedException("cannot handle svc defn of type " + (Serializable)(ct == null ? "NULL" : ct.getClass()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void leaveMemberExpr(MemberExpr expr, boolean done) {
        if (this.results.size() > 1) {
            throw new CantHappenException("only one result should come back");
        }
        if (this.results.size() == 1) {
            Object e = this.results.get(0);
            if (e instanceof CastExpr) {
                CastExpr ce = (CastExpr)e;
                TypeReference tr = ce.type;
                if (!(tr.namedDefn() instanceof StructDefn)) {
                    throw new HaventConsideredThisException("Can only handle cast-to-struct at the moment, not " + tr.getClass());
                }
                this.sd = (StructDefn)tr.namedDefn();
                String fld = ((UnresolvedVar)expr.fld).var;
                this.acorFrom = this.sd.getAccessor(fld);
                if (this.acorFrom == null) {
                    throw new NotImplementedException("There is no acor " + fld);
                }
                this.expargs = 0;
                this.obj = ce.val;
            } else {
                if (!(e instanceof MakeAcor)) throw new HaventConsideredThisException("e is of type " + e.getClass());
                this.acorFrom = (FieldAccessor)((Object)((UnresolvedVar)expr.fld).defn());
                this.obj = (MakeAcor)e;
            }
        }
        if (expr.boundEarly()) {
            if (this.obj != null) throw new CantHappenException("this suggests the field is a member expr");
            this.obj = expr;
            this.figureDestinationType();
            return;
        } else if (this.odctor != null) {
            this.convertObjectCtor(expr);
            return;
        } else if (this.acorFrom != null) {
            this.nv.result(this.acorFrom.acor(this.obj));
            return;
        } else {
            if (this.sendMeth == null) throw new HaventConsideredThisException("cannot convert " + expr);
            if (this.isAcor) {
                this.nv.result(new MakeAcor(expr.location(), this.sendMeth, this.obj, this.expargs));
                return;
            } else {
                this.nv.result(new MakeSend(expr.location(), this.sendMeth, this.obj, this.expargs));
            }
        }
    }

    private void convertObjectCtor(MemberExpr expr) {
        UnresolvedVar fn = new UnresolvedVar(expr.fld.location(), ((UnresolvedVar)expr.fld).var);
        fn.bind(this.odctor);
        ArrayList<UnresolvedVar> args = new ArrayList<UnresolvedVar>();
        for (ObjectContract oc : this.od.contracts) {
            if (this.oah.hasImplements()) {
                NamedType parent = this.oah.getImplements().getParent();
                if (parent instanceof AgentDefinition || parent instanceof CardDefinition) {
                    UnresolvedVar ret;
                    RequiresHolder ad = (RequiresHolder)((Object)parent);
                    RequiresContract found = null;
                    for (RequiresContract rc : ad.requires()) {
                        if (rc.actualType() != oc.implementsType().namedDefn()) continue;
                        found = rc;
                        break;
                    }
                    Provides prov = ad.providesContract(oc.implementsType().namedDefn().name());
                    if (found != null) {
                        ret = new UnresolvedVar(expr.fld.location(), found.referAsVar);
                        ret.bind(found);
                        args.add(ret);
                        continue;
                    }
                    if (prov != null) {
                        ret = new UnresolvedVar(expr.fld.location(), prov.referAsVar);
                        ret.bind(prov);
                        args.add(ret);
                        continue;
                    }
                    this.errors.message(expr.fld.location(), "there is no available implementation of " + oc.implementsType().namedDefn().name().uniqueName());
                    continue;
                }
                throw new NotImplementedException("there are other valid cases ... and probably invalid ones too");
            }
            throw new NotImplementedException("there are other valid cases ... and probably invalid ones too");
        }
        if (args.isEmpty()) {
            this.nv.result(fn);
        } else {
            this.nv.result(new ApplyExpr(expr.location, (Object)fn, args.toArray(new Expr[args.size()])));
        }
    }
}

