/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.method;

import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.method.AccessorConvertor;
import org.flasck.flas.method.MessageConvertor;
import org.flasck.flas.method.MethodConvertor;
import org.flasck.flas.method.UDDConvertor;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.ObjectCtor;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parsedForm.ut.UnitTestAssert;
import org.flasck.flas.parsedForm.ut.UnitTestIdentical;
import org.flasck.flas.parsedForm.ut.UnitTestInvoke;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryReader;

public class ConvertRepositoryMethods
extends LeafAdapter {
    private final NestedVisitor sv;
    private final ErrorReporter errors;
    private final RepositoryReader repository;

    public ConvertRepositoryMethods(NestedVisitor sv, ErrorReporter errors, RepositoryReader repository) {
        this.sv = sv;
        this.errors = errors;
        this.repository = repository;
        sv.push(this);
    }

    @Override
    public void visitFunction(FunctionDefinition fn) {
        new AccessorConvertor(this.sv, this.errors, this.repository, fn.state());
    }

    @Override
    public void visitObjectMethod(ObjectMethod e) {
        this.sv.push(new MethodConvertor(this.errors, this.sv, e));
    }

    @Override
    public void visitObjectCtor(ObjectCtor e) {
        this.sv.push(new MethodConvertor(this.errors, this.sv, e));
    }

    @Override
    public void visitStructField(StructField sf) {
        if (sf.init == null) {
            return;
        }
        this.sv.push(new MessageConvertor(this.errors, this.sv, null, null));
    }

    @Override
    public void visitTemplateBindingOption(TemplateBindingOption option) {
        new AccessorConvertor(this.sv, this.errors, this.repository, null);
    }

    @Override
    public void visitTemplateStyling(TemplateStylingOption option) {
        new AccessorConvertor(this.sv, this.errors, this.repository, null);
    }

    @Override
    public void visitUnitDataDeclaration(UnitDataDeclaration udd) {
        new UDDConvertor(this.sv, this.errors);
    }

    @Override
    public void visitUnitTestAssert(UnitTestAssert e) {
        new AccessorConvertor(this.sv, this.errors, this.repository, null);
    }

    @Override
    public void visitUnitTestIdentical(UnitTestIdentical e) {
        new AccessorConvertor(this.sv, this.errors, this.repository, null);
    }

    @Override
    public void visitUnitTestInvoke(UnitTestInvoke e) {
        this.sv.push(new MessageConvertor(this.errors, this.sv, null, null));
    }
}

