/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.method;

import java.util.ArrayList;
import org.flasck.flas.commonBase.ApplyExpr;
import org.flasck.flas.commonBase.Expr;
import org.flasck.flas.commonBase.MemberExpr;
import org.flasck.flas.commonBase.ParenExpr;
import org.flasck.flas.commonBase.StringLiteral;
import org.flasck.flas.commonBase.names.FunctionName;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lifting.NestedVarReader;
import org.flasck.flas.parsedForm.AccessorHolder;
import org.flasck.flas.parsedForm.AgentDefinition;
import org.flasck.flas.parsedForm.CardDefinition;
import org.flasck.flas.parsedForm.CastExpr;
import org.flasck.flas.parsedForm.ContractReferencer;
import org.flasck.flas.parsedForm.FieldAccessor;
import org.flasck.flas.parsedForm.FunctionDefinition;
import org.flasck.flas.parsedForm.IntroduceVar;
import org.flasck.flas.parsedForm.MakeSend;
import org.flasck.flas.parsedForm.ObjectActionHandler;
import org.flasck.flas.parsedForm.ObjectContract;
import org.flasck.flas.parsedForm.ObjectDefn;
import org.flasck.flas.parsedForm.ObjectMethod;
import org.flasck.flas.parsedForm.Provides;
import org.flasck.flas.parsedForm.RequiresContract;
import org.flasck.flas.parsedForm.RequiresHolder;
import org.flasck.flas.parsedForm.StateHolder;
import org.flasck.flas.parsedForm.StructDefn;
import org.flasck.flas.parsedForm.StructField;
import org.flasck.flas.parsedForm.TemplateBindingOption;
import org.flasck.flas.parsedForm.TemplateNestedField;
import org.flasck.flas.parsedForm.TemplateStylingOption;
import org.flasck.flas.parsedForm.TypeReference;
import org.flasck.flas.parsedForm.TypedPattern;
import org.flasck.flas.parsedForm.UnresolvedVar;
import org.flasck.flas.parsedForm.VarPattern;
import org.flasck.flas.parsedForm.assembly.ApplicationRouting;
import org.flasck.flas.parsedForm.ut.UnitTestAssert;
import org.flasck.flas.parsedForm.ut.UnitTestIdentical;
import org.flasck.flas.parser.ut.UnitDataDeclaration;
import org.flasck.flas.repository.LeafAdapter;
import org.flasck.flas.repository.LoadBuiltins;
import org.flasck.flas.repository.NestedVisitor;
import org.flasck.flas.repository.RepositoryEntry;
import org.flasck.flas.repository.RepositoryReader;
import org.flasck.flas.tc3.NamedType;
import org.flasck.flas.tc3.PolyInstance;
import org.flasck.flas.tc3.Type;
import org.zinutils.exceptions.CantHappenException;
import org.zinutils.exceptions.HaventConsideredThisException;
import org.zinutils.exceptions.NotImplementedException;

public class AccessorConvertor
extends LeafAdapter {
    private final NestedVisitor sv;
    private final ErrorReporter errors;
    private final RepositoryReader repository;
    private ContractReferencer cr = null;

    public AccessorConvertor(NestedVisitor sv, ErrorReporter errors, RepositoryReader repository, StateHolder stateHolder) {
        this.sv = sv;
        this.errors = errors;
        this.repository = repository;
        if (stateHolder instanceof ContractReferencer) {
            this.cr = (ContractReferencer)((Object)stateHolder);
        }
        sv.push(this);
    }

    @Override
    public void leaveFunction(FunctionDefinition a) {
        this.sv.result(null);
    }

    @Override
    public void postUnitTestAssert(UnitTestAssert a) {
        this.sv.result(null);
    }

    @Override
    public void postUnitTestIdentical(UnitTestIdentical a) {
        this.sv.result(null);
    }

    @Override
    public void leaveTemplateBindingOption(TemplateBindingOption option) {
        this.sv.result(null);
    }

    @Override
    public void leaveTemplateStyling(TemplateStylingOption option) {
        this.sv.result(null);
    }

    @Override
    public boolean visitMemberExpr(MemberExpr expr, int nargs) {
        if (expr.boundEarly()) {
            RepositoryEntry defn = expr.defn();
            if (!(defn instanceof FunctionDefinition) && !(defn instanceof StructDefn)) {
                throw new HaventConsideredThisException("was not a function");
            }
            UnresolvedVar uv = new UnresolvedVar(expr.location, "expr");
            uv.bind(defn);
            expr.conversion(uv);
            return true;
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void leaveMemberExpr(MemberExpr expr, boolean done) {
        AccessorHolder ah;
        UnresolvedVar meth;
        block42: {
            RepositoryEntry defn;
            if (done) {
                return;
            }
            Expr from = expr.from;
            while (from instanceof ParenExpr) {
                from = (Expr)((ParenExpr)from).expr;
            }
            if (from instanceof UnresolvedVar) {
                uv = (UnresolvedVar)from;
                defn = ((UnresolvedVar)uv).defn();
            } else if (from instanceof TypeReference) {
                uv = (TypeReference)from;
                defn = (RepositoryEntry)((Object)((TypeReference)uv).namedDefn());
            } else if (from instanceof MemberExpr) {
                MemberExpr me = (MemberExpr)from;
                defn = me.defn();
            } else if (from instanceof ApplyExpr) {
                defn = (RepositoryEntry)((Object)expr.containerType());
            } else {
                if (!(from instanceof CastExpr)) throw new NotImplementedException("cannot handle member of " + from.getClass());
                defn = (RepositoryEntry)((Object)((CastExpr)from).type.namedDefn());
            }
            if (defn == null) {
                throw new CantHappenException("defn is null from " + from + " " + from.getClass());
            }
            if (defn instanceof PolyInstance) {
                PolyInstance pi = (PolyInstance)defn;
                defn = (RepositoryEntry)((Object)pi.struct());
            }
            meth = (UnresolvedVar)expr.fld;
            if (defn instanceof IntroduceVar && (defn = (RepositoryEntry)((Object)((IntroduceVar)defn).introducedAs())) == null) {
                throw new CantHappenException("defn is null from " + defn);
            }
            if (defn instanceof UnitDataDeclaration) {
                StateHolder sh;
                UnitDataDeclaration udd = (UnitDataDeclaration)defn;
                NamedType td = udd.ofType.namedDefn();
                if (td instanceof StateHolder && (sh = (StateHolder)((Object)td)).state() != null && sh.state().hasMember(meth.var)) {
                    expr.conversion(new ApplyExpr(expr.location, (Object)LoadBuiltins.probeState, expr.from, new StringLiteral(meth.location, meth.var)));
                    return;
                }
                Object entry = this.repository.get(FunctionName.function(meth.location, td.name(), meth.var).uniqueName());
                if (entry != null && entry instanceof FunctionDefinition) {
                    UnresolvedVar call = new UnresolvedVar(meth.location, meth.var);
                    call.bind((RepositoryEntry)entry);
                    expr.conversion(new ApplyExpr(expr.location, (Object)call, new ApplyExpr(expr.location, (Object)LoadBuiltins.getUnderlying, from)));
                    return;
                }
                if (td instanceof AccessorHolder && ((AccessorHolder)((Object)td)).getAccessor(meth.var) != null) {
                    ah = (AccessorHolder)((Object)td);
                    break block42;
                } else {
                    if (td instanceof ObjectDefn && ((ObjectDefn)td).getMethod(meth.var) != null) {
                        ObjectDefn od = (ObjectDefn)td;
                        ObjectMethod m = od.getMethod(meth.var);
                        expr.conversion(new MakeSend(expr.location(), m.name(), from, m.argCount()));
                        return;
                    }
                    this.errors.message(meth.location, "there is no suitable value for '" + meth.var + "' on " + td.name().uniqueName());
                    return;
                }
            }
            if (defn instanceof StructDefn) {
                ah = (AccessorHolder)((Object)defn);
            } else {
                if (defn instanceof ObjectDefn) {
                    ObjectDefn od = (ObjectDefn)defn;
                    ObjectActionHandler odctor = od.getConstructor(meth.var);
                    if (odctor == null) {
                        throw new CantHappenException("no constructor " + meth.var);
                    }
                    this.convertObjectCtor(od, odctor, expr);
                    return;
                }
                if (defn instanceof TypedPattern) {
                    TypedPattern tp = (TypedPattern)defn;
                    Type ty = tp.type();
                    if (ty instanceof PolyInstance) {
                        ty = ((PolyInstance)ty).struct();
                    }
                    ah = (AccessorHolder)((Object)ty);
                } else if (defn instanceof VarPattern) {
                    Type ty = ((VarPattern)defn).type();
                    if (ty == null) {
                        throw new CantHappenException("type of " + defn + " has not been bound");
                    }
                    if (ty instanceof PolyInstance) {
                        ty = ((PolyInstance)ty).struct();
                    }
                    if (!(ty instanceof AccessorHolder)) {
                        this.errors.message(meth.location, "cannot access members of " + ty.signature());
                        return;
                    }
                    ah = (AccessorHolder)((Object)ty);
                } else if (defn instanceof FunctionDefinition) {
                    FunctionDefinition fn = (FunctionDefinition)defn;
                    if (fn.argCountWithoutHolder() == 0) {
                        ah = fn.hasState() ? (AccessorHolder)((Object)fn.type().get(1)) : (AccessorHolder)((Object)fn.type());
                    } else {
                        NestedVarReader nv = fn.nestedVars();
                        if (nv.patterns().size() != fn.argCountWithoutHolder()) throw new NotImplementedException("cannot extract object from " + defn.getClass() + " with " + fn.argCount());
                        ah = (AccessorHolder)((Object)fn.type().get(nv.size() + (fn.hasState() ? 1 : 0)));
                    }
                } else if (defn instanceof StructField) {
                    ah = (AccessorHolder)((Object)((StructField)defn).type());
                } else if (defn instanceof TemplateNestedField) {
                    ah = (AccessorHolder)((Object)((TemplateNestedField)defn).type());
                } else {
                    if (!(defn instanceof ApplicationRouting.CardBinding)) {
                        if (!(defn instanceof ApplicationRouting)) throw new NotImplementedException("cannot extract object from " + defn.getClass());
                        expr.conversion(new ApplyExpr(expr.location, (Object)LoadBuiltins.probeState, expr.from, new StringLiteral(meth.location, meth.var)));
                        return;
                    }
                    StateHolder sh = ((ApplicationRouting.CardBinding)defn).type();
                    if (sh.state() != null && sh.state().hasMember(meth.var)) {
                        expr.conversion(new ApplyExpr(expr.location, (Object)LoadBuiltins.probeState, expr.from, new StringLiteral(meth.location, meth.var)));
                        return;
                    }
                    this.errors.message(meth.location, "there is no suitable value for '" + meth.var + "' on " + sh.name().uniqueName());
                    return;
                }
            }
        }
        FieldAccessor acc = ah.getAccessor(meth.var);
        if (acc == null) {
            this.errors.message(meth.location, "there is no accessor '" + meth.var + "' on " + ah.name().uniqueName());
            return;
        }
        expr.conversion(acc.acor(expr.from));
        if (expr.defn() != null) return;
        expr.bind((RepositoryEntry)((Object)acc), false);
    }

    private void convertObjectCtor(ObjectDefn od, ObjectActionHandler odctor, MemberExpr expr) {
        UnresolvedVar fn = new UnresolvedVar(expr.fld.location(), ((UnresolvedVar)expr.fld).var);
        fn.bind(odctor);
        ArrayList<UnresolvedVar> args = new ArrayList<UnresolvedVar>();
        for (ObjectContract oc : od.contracts) {
            if (this.cr != null) {
                NamedType parent = this.cr.getParent();
                if (parent instanceof AgentDefinition || parent instanceof CardDefinition) {
                    UnresolvedVar ret;
                    RequiresHolder ad = (RequiresHolder)((Object)parent);
                    RequiresContract found = null;
                    for (RequiresContract rc : ad.requires()) {
                        if (rc.actualType() != oc.implementsType().namedDefn()) continue;
                        found = rc;
                        break;
                    }
                    Provides prov = ad.providesContract(oc.implementsType().namedDefn().name());
                    if (found != null) {
                        ret = new UnresolvedVar(expr.fld.location(), found.referAsVar);
                        ret.bind(found);
                        args.add(ret);
                        continue;
                    }
                    if (prov != null) {
                        ret = new UnresolvedVar(expr.fld.location(), prov.referAsVar);
                        ret.bind(prov);
                        args.add(ret);
                        continue;
                    }
                    this.errors.message(expr.fld.location(), "there is no available implementation of " + oc.implementsType().namedDefn().name().uniqueName());
                    continue;
                }
                throw new NotImplementedException("there are other valid cases ... and probably invalid ones too");
            }
            throw new NotImplementedException("there are other valid cases ... and probably invalid ones too");
        }
        if (args.isEmpty()) {
            expr.conversion(fn);
        } else {
            expr.conversion(new ApplyExpr(expr.location, (Object)fn, args.toArray(new Expr[args.size()])));
        }
    }
}

