/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.File;
import java.net.URI;
import java.util.TreeSet;
import org.flasck.flas.Configuration;
import org.flasck.flas.compiler.CardDataListener;
import org.flasck.flas.compiler.FLASCompiler;
import org.flasck.flas.compiler.TaskQueue;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.lsp.CompileTask;
import org.flasck.flas.lsp.FLASLanguageClient;
import org.flasck.flas.lsp.WorkspaceFileNameComparator;
import org.flasck.flas.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.ziniki.splitter.CardData;
import org.ziniki.splitter.MetaEntry;
import org.ziniki.splitter.SplitMetaData;
import org.zinutils.utils.FileUtils;

public class Root
implements CardDataListener {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private final FLASLanguageClient client;
    private final ErrorReporter errors;
    private final TaskQueue taskQ;
    public final URI uri;
    public final File root;
    private final TreeSet<File> files = new TreeSet(new WorkspaceFileNameComparator());
    private FLASCompiler compiler;

    public Root(FLASLanguageClient client, ErrorReporter errors, TaskQueue taskQ, URI uri) {
        this.client = client;
        this.errors = errors;
        this.taskQ = taskQ;
        this.uri = uri;
        this.root = new File(uri.getPath());
    }

    public void configure(File flasHome) {
        logger.info("configuring " + this.root + " with flas home " + flasHome);
        Configuration config = new Configuration(this.errors, new String[0]);
        config.projectDir = this.root;
        config.includeFrom.add(new File(flasHome, "flim"));
        config.includeFrom.add(new File(flasHome, "userflim"));
        Repository repository = new Repository();
        this.compiler = new FLASCompiler(config, this.errors, repository, this);
        this.compiler.taskQueue(this.taskQ);
        this.taskQ.loadFLIM(this.uri, this.compiler);
    }

    public void setCardsFolder(String cardsFolder) {
        if (cardsFolder == null) {
            this.compiler.setCardsFolder(null);
        } else {
            this.compiler.setCardsFolder(new File(this.root, cardsFolder));
        }
        this.taskQ.readyWhenYouAre(this.uri, this.compiler);
    }

    public void gatherFiles() {
        this.files.clear();
        for (File f : FileUtils.findFilesUnderMatching((File)this.root, (String)"*")) {
            if (!WorkspaceFileNameComparator.isValidExtension(FileUtils.extension((String)f.getName()))) continue;
            this.files.add(f);
        }
        for (File f : this.files) {
            this.errors.logMessage("gathered " + f);
        }
    }

    public void compileAll() {
        for (File f : this.files) {
            this.taskQ.submit(new CompileTask(this.compiler, this.uri.resolve(f.getPath()), null));
        }
    }

    public void dispatch(URI uri, String text) {
        if (WorkspaceFileNameComparator.isValidExtension(FileUtils.extension((String)uri.getPath()))) {
            logger.info("Submitting file for compilation for " + uri);
            this.taskQ.submit(new CompileTask(this.compiler, uri, text));
        }
    }

    @Override
    public void provideWebData(SplitMetaData md) {
        JsonObject cards = new JsonObject();
        for (String card : md) {
            JsonObject fields = new JsonObject();
            CardData cd = md.forCard(card);
            for (MetaEntry me : cd) {
                fields.addProperty(me.key(), me.value().toString());
            }
            cards.add(card, (JsonElement)fields);
        }
        JsonObject send = new JsonObject();
        send.addProperty("uri", this.uri.toString().replaceAll("/*$", ""));
        send.add("cards", (JsonElement)cards);
        this.client.sendCardInfo(send);
    }
}

