/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import java.net.URI;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.flasck.flas.errors.FLASError;
import org.flasck.flas.lsp.DiagnosticHandler;
import org.flasck.flas.lsp.LSPErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zinutils.collections.ListMap;

public class Phase2Handler
extends DiagnosticHandler
implements LSPErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private final LanguageClient client;
    private final URI workspaceUri;
    private final ListMap<URI, Diagnostic> diagnostics = new ListMap();

    public Phase2Handler(LanguageClient client, URI workspace) {
        this.client = client;
        this.workspaceUri = workspace;
    }

    @Override
    public void handle(FLASError e) {
        logger.info("handling phase 2 error " + e);
        Diagnostic diagnostic = this.makeDiagnostic(this.workspaceUri, e);
        URI uri = this.workspaceUri;
        if (e.loc != null && e.loc.file != null) {
            uri = this.workspaceUri.resolve(e.loc.file);
        }
        this.diagnostics.add((Object)uri, (Object)diagnostic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(List<URI> broken) {
        for (URI uri : this.diagnostics.keySet()) {
            List report = this.diagnostics.get((Object)uri);
            if (report.isEmpty()) continue;
            logger.info("reporting phase 2 diagnostics for " + uri);
            broken.add(uri);
            LanguageClient languageClient = this.client;
            synchronized (languageClient) {
                this.client.publishDiagnostics(new PublishDiagnosticsParams(uri.toString(), report));
            }
        }
    }

    @Override
    public int errorCount() {
        return this.diagnostics.totalSize();
    }
}

