/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.PublishDiagnosticsParams;
import org.eclipse.lsp4j.services.LanguageClient;
import org.flasck.flas.errors.FLASError;
import org.flasck.flas.lsp.DiagnosticHandler;
import org.flasck.flas.lsp.LSPErrorHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Phase1Handler
extends DiagnosticHandler
implements LSPErrorHandler {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private final LanguageClient client;
    private final URI processingUri;
    private final List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public Phase1Handler(LanguageClient client, URI uri) {
        this.client = client;
        this.processingUri = uri;
    }

    @Override
    public void handle(FLASError e) {
        logger.info("saw error: " + e + " on " + this.processingUri);
        Diagnostic diagnostic = this.makeDiagnostic(this.processingUri, e);
        this.diagnostics.add(diagnostic);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void done(List<URI> broken) {
        if (this.diagnostics.isEmpty()) {
            broken.remove(this.processingUri);
        } else {
            broken.add(this.processingUri);
        }
        logger.info("done processing " + this.processingUri + ": sending " + this.diagnostics.size() + " diagnostics");
        LanguageClient languageClient = this.client;
        synchronized (languageClient) {
            this.client.publishDiagnostics(new PublishDiagnosticsParams(this.processingUri.toString(), this.diagnostics));
        }
    }

    @Override
    public int errorCount() {
        return this.diagnostics.size();
    }
}

