/*
 * Decompiled with CFR 0.152.
 */
package org.flasck.flas.lsp;

import java.io.File;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.services.LanguageClient;
import org.flasck.flas.blockForm.InputPosition;
import org.flasck.flas.commonBase.Locatable;
import org.flasck.flas.errors.ErrorMark;
import org.flasck.flas.errors.ErrorReporter;
import org.flasck.flas.errors.FLASError;
import org.flasck.flas.errors.FatErrorAPI;
import org.flasck.flas.grammar.tracking.LoggableToken;
import org.flasck.flas.lsp.LSPErrorHandler;
import org.flasck.flas.lsp.Phase1Handler;
import org.flasck.flas.lsp.Phase2Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LSPErrorForwarder
extends FatErrorAPI
implements ErrorReporter {
    private static final Logger logger = LoggerFactory.getLogger((String)"FLASLSP");
    private LanguageClient client;
    private LSPErrorHandler handler;

    public void connect(LanguageClient client) {
        this.client = client;
    }

    @Override
    public void beginPhase1(URI uri) {
        logger.info("beginning processing for " + uri);
        this.handler = new Phase1Handler(this.client, uri);
    }

    @Override
    public void beginPhase2(URI uri) {
        logger.info("beginning phase2 processing for " + uri);
        this.handler = new Phase2Handler(this.client, uri.resolve("."));
    }

    @Override
    public ErrorReporter message(FLASError e) {
        if (this.handler == null) {
            logger.info("message arrived with no handler: " + e);
        } else {
            this.handler.handle(e);
        }
        return this;
    }

    @Override
    public void doneProcessing(List<URI> broken) {
        this.handler.done(broken);
        this.handler = null;
    }

    @Override
    public boolean hasErrors() {
        if (this.handler == null) {
            return false;
        }
        return this.handler.errorCount() > 0;
    }

    @Override
    public ErrorMark mark() {
        final int cnt = this.handler == null ? 0 : this.handler.errorCount();
        return new ErrorMark(){

            @Override
            public boolean hasMoreNow() {
                if (LSPErrorForwarder.this.handler == null) {
                    return false;
                }
                return LSPErrorForwarder.this.handler.errorCount() > cnt;
            }
        };
    }

    @Override
    public void showFromMark(ErrorMark mark, Writer pw, int ind) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void logMessage(String s) {
        LanguageClient languageClient = this.client;
        synchronized (languageClient) {
            this.client.logMessage(new MessageParams(MessageType.Log, s));
        }
    }

    @Override
    public void track(File f) {
        System.out.println("    " + f.getName());
    }

    @Override
    public <T extends LoggableToken> T logParsingToken(T token) {
        return token;
    }

    @Override
    public void logReduction(String ruleId, Locatable from, Locatable to) {
        this.logReduction(ruleId, from.location(), to.location());
    }

    @Override
    public void logReduction(String ruleId, InputPosition from, InputPosition to) {
    }
}

